/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import io.github.cadiboo.nocubes.config.NoCubesConfig;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;

public final class RollingProfiler {
    private final AtomicInteger index = new AtomicInteger();
    private final long[] records;

    public RollingProfiler(int size) {
        this.records = new long[size];
    }

    public boolean recordElapsedNanos(long startNanos) {
        if (!NoCubesConfig.Client.debugEnabled) {
            return false;
        }
        long elapsed = System.nanoTime() - startNanos;
        int i = this.index.incrementAndGet() % this.records.length;
        this.records[i] = elapsed;
        return i == 0;
    }

    public double average() {
        double sum = 0.0;
        long[] records = this.records;
        int length = records.length;
        for (int i = 0; i < length; ++i) {
            sum += (double)records[i];
        }
        return sum / (double)length;
    }

    public int size() {
        return this.records.length;
    }

    public void recordAndLogElapsedNanosChunk(long start, String description) {
        if (this.recordElapsedNanos(start)) {
            LogManager.getLogger((String)("Render chunk " + description)).debug("Average {}ms over the past {} chunks", (Object)(this.average() / 1000000.0), (Object)this.size());
        }
    }
}

