/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import io.github.cadiboo.nocubes.config.ColorParser;
import io.github.cadiboo.nocubes.util.Face;
import io.github.cadiboo.nocubes.util.Vec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenderHelper {
    private static final Logger LOG = LogManager.getLogger();

    public static void reloadAllChunks(String because, Object ... becauseArgs) {
        LOG.debug(() -> "Re-rendering chunks because " + because.formatted(becauseArgs));
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.execute(() -> ((LevelRenderer)minecraft.f_91060_).m_109818_());
    }

    public static void drawLinePosColorFromAdd(BlockPos offset, Vec start, Vec add, ColorParser.Color color, VertexConsumer buffer, PoseStack matrix, Vec3 camera) {
        float startX = (float)((double)offset.m_123341_() - camera.f_82479_ + (double)start.x);
        float startY = (float)((double)offset.m_123342_() - camera.f_82480_ + (double)start.y);
        float startZ = (float)((double)offset.m_123343_() - camera.f_82481_ + (double)start.z);
        RenderHelper.line(buffer, matrix, color, startX, startY, startZ, startX + add.x, startY + add.y, startZ + add.z);
    }

    public static void drawLinePosColorFromTo(BlockPos startOffset, Vec start, BlockPos endOffset, Vec end, ColorParser.Color color, VertexConsumer buffer, PoseStack matrix, Vec3 camera) {
        RenderHelper.line(buffer, matrix, color, (float)((double)((float)startOffset.m_123341_() + start.x) - camera.f_82479_), (float)((double)((float)startOffset.m_123342_() + start.y) - camera.f_82480_), (float)((double)((float)startOffset.m_123343_() + start.z) - camera.f_82481_), (float)((double)((float)endOffset.m_123341_() + end.x) - camera.f_82479_), (float)((double)((float)endOffset.m_123342_() + end.y) - camera.f_82480_), (float)((double)((float)endOffset.m_123343_() + end.z) - camera.f_82481_));
    }

    public static void drawFacePosColor(Face face, Vec3 camera, BlockPos pos, ColorParser.Color color, VertexConsumer buffer, PoseStack matrix) {
        Vec v0 = face.v0;
        Vec v1 = face.v1;
        Vec v2 = face.v2;
        Vec v3 = face.v3;
        double x = (double)pos.m_123341_() - camera.f_82479_;
        double y = (double)pos.m_123342_() - camera.f_82480_;
        double z = (double)pos.m_123343_() - camera.f_82481_;
        float v0x = (float)(x + (double)v0.x);
        float v1x = (float)(x + (double)v1.x);
        float v2x = (float)(x + (double)v2.x);
        float v3x = (float)(x + (double)v3.x);
        float v0y = (float)(y + (double)v0.y);
        float v1y = (float)(y + (double)v1.y);
        float v2y = (float)(y + (double)v2.y);
        float v3y = (float)(y + (double)v3.y);
        float v0z = (float)(z + (double)v0.z);
        float v1z = (float)(z + (double)v1.z);
        float v2z = (float)(z + (double)v2.z);
        float v3z = (float)(z + (double)v3.z);
        RenderHelper.line(buffer, matrix, color, v0x, v0y, v0z, v1x, v1y, v1z);
        RenderHelper.line(buffer, matrix, color, v1x, v1y, v1z, v2x, v2y, v2z);
        RenderHelper.line(buffer, matrix, color, v2x, v2y, v2z, v3x, v3y, v3z);
        RenderHelper.line(buffer, matrix, color, v3x, v3y, v3z, v0x, v0y, v0z);
    }

    public static void drawShape(PoseStack stack, VertexConsumer buffer, VoxelShape shape, BlockPos pos, Vec3 camera, ColorParser.Color color) {
        double x = (double)pos.m_123341_() - camera.f_82479_;
        double y = (double)pos.m_123342_() - camera.f_82480_;
        double z = (double)pos.m_123343_() - camera.f_82481_;
        shape.m_83224_((x0, y0, z0, x1, y1, z1) -> RenderHelper.line(buffer, stack, color, (float)(x + x0), (float)(y + y0), (float)(z + z0), (float)(x + x1), (float)(y + y1), (float)(z + z1)));
    }

    public static void line(VertexConsumer buffer, PoseStack matrix, ColorParser.Color color, float x0, float y0, float z0, float x1, float y1, float z1) {
        PoseStack.Pose currentTransform = matrix.m_85850_();
        Matrix4f pose = currentTransform.m_85861_();
        Matrix3f normal = currentTransform.m_85864_();
        float transformedX0 = RenderHelper.getTransformX(pose, x0, y0, z0, 1.0f);
        float transformedY0 = RenderHelper.getTransformY(pose, x0, y0, z0, 1.0f);
        float transformedZ0 = RenderHelper.getTransformZ(pose, x0, y0, z0, 1.0f);
        float transformedX1 = RenderHelper.getTransformX(pose, x1, y1, z1, 1.0f);
        float transformedY1 = RenderHelper.getTransformY(pose, x1, y1, z1, 1.0f);
        float transformedZ1 = RenderHelper.getTransformZ(pose, x1, y1, z1, 1.0f);
        float normalX = x1 - x0;
        float normalY = y1 - y0;
        float normalZ = z1 - z0;
        float length = Mth.m_14116_((float)(normalX * normalX + normalY * normalY + normalZ * normalZ));
        float transformedNormalX = RenderHelper.getTransformX(normal, normalX /= length, normalY /= length, normalZ /= length);
        float transformedNormalY = RenderHelper.getTransformY(normal, normalX, normalY, normalZ);
        float transformedNormalZ = RenderHelper.getTransformZ(normal, normalX, normalY, normalZ);
        buffer.m_5483_((double)transformedX0, (double)transformedY0, (double)transformedZ0).m_6122_(color.red, color.green, color.blue, color.alpha).m_5601_(transformedNormalX, transformedNormalY, transformedNormalZ).m_5752_();
        buffer.m_5483_((double)transformedX1, (double)transformedY1, (double)transformedZ1).m_6122_(color.red, color.green, color.blue, color.alpha).m_5601_(transformedNormalX, transformedNormalY, transformedNormalZ).m_5752_();
    }

    public static void vertex(VertexConsumer buffer, PoseStack matrix, float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        PoseStack.Pose currentTransform = matrix.m_85850_();
        Matrix4f pose = currentTransform.m_85861_();
        Matrix3f normal = currentTransform.m_85864_();
        float transformedX = RenderHelper.getTransformX(pose, x, y, z, 1.0f);
        float transformedY = RenderHelper.getTransformY(pose, x, y, z, 1.0f);
        float transformedZ = RenderHelper.getTransformZ(pose, x, y, z, 1.0f);
        float transformedNormalX = RenderHelper.getTransformX(normal, normalX, normalY, normalZ);
        float transformedNormalY = RenderHelper.getTransformY(normal, normalX, normalY, normalZ);
        float transformedNormalZ = RenderHelper.getTransformZ(normal, normalX, normalY, normalZ);
        buffer.m_5954_(transformedX, transformedY, transformedZ, red, green, blue, alpha, texU, texV, overlayUV, lightmapUV, transformedNormalX, transformedNormalY, transformedNormalZ);
    }

    public static float getTransformX(Matrix3f matrix, float x, float y, float z) {
        return matrix.f_8134_ * x + matrix.f_8135_ * y + matrix.f_8136_ * z;
    }

    public static float getTransformY(Matrix3f matrix, float x, float y, float z) {
        return matrix.f_8137_ * x + matrix.f_8138_ * y + matrix.f_8139_ * z;
    }

    public static float getTransformZ(Matrix3f matrix, float x, float y, float z) {
        return matrix.f_8140_ * x + matrix.f_8141_ * y + matrix.f_8142_ * z;
    }

    public static float getTransformX(Matrix4f matrix, float x, float y, float z, float w) {
        return matrix.f_27603_ * x + matrix.f_27604_ * y + matrix.f_27605_ * z + matrix.f_27606_ * w;
    }

    public static float getTransformY(Matrix4f matrix, float x, float y, float z, float w) {
        return matrix.f_27607_ * x + matrix.f_27608_ * y + matrix.f_27609_ * z + matrix.f_27610_ * w;
    }

    public static float getTransformZ(Matrix4f matrix, float x, float y, float z, float w) {
        return matrix.f_27611_ * x + matrix.f_27612_ * y + matrix.f_27613_ * z + matrix.f_27614_ * w;
    }

    public static float getTransformW(Matrix4f matrix, float x, float y, float z, float w) {
        return matrix.f_27615_ * x + matrix.f_27616_ * y + matrix.f_27617_ * z + matrix.f_27618_ * w;
    }
}

