/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import com.google.common.collect.Lists;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.RenderHelper;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.network.C2SRequestUpdateSmoothable;
import io.github.cadiboo.nocubes.network.NoCubesNetwork;
import io.github.cadiboo.nocubes.util.ModUtil;
import java.util.ArrayList;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class KeyMappings {
    private static final Logger LOG = LogManager.getLogger();

    public static void register(RegisterKeyMappingsEvent registerEvent, IEventBus forgeBus) {
        LOG.debug("Registering keybindings");
        ArrayList keybindings = Lists.newArrayList((Object[])new Pair[]{KeyMappings.makeKeybinding(registerEvent, "toggleVisuals", 79, KeyMappings::toggleVisuals), KeyMappings.makeKeybinding(registerEvent, "toggleSmoothable", 78, KeyMappings::toggleLookedAtSmoothable)});
        forgeBus.addListener(tickEvent -> {
            if (tickEvent.phase != TickEvent.Phase.END) {
                return;
            }
            for (Pair keybinding : keybindings) {
                if (!((KeyMapping)keybinding.getKey()).m_90859_()) continue;
                LOG.debug("Keybinding {} pressed", (Object)((KeyMapping)keybinding.getKey()).m_90860_());
                ((Runnable)keybinding.getValue()).run();
            }
        });
    }

    private static Pair<KeyMapping, Runnable> makeKeybinding(RegisterKeyMappingsEvent event, String name, int key, Runnable action) {
        LOG.debug("Registering keybinding {}", (Object)name);
        KeyMapping mapping = new KeyMapping("nocubes.key." + name, key, "nocubes.keycategory");
        event.register(mapping);
        return Pair.of((Object)mapping, (Object)action);
    }

    private static void toggleVisuals() {
        if (NoCubesConfig.Client.render && NoCubesConfig.Server.forceVisuals) {
            ClientUtil.warnPlayer("nocubes.notification.visualsForcedByServer", new Object[0]);
            return;
        }
        NoCubesConfig.Client.updateRender(!NoCubesConfig.Client.render);
        RenderHelper.reloadAllChunks("toggleVisuals was pressed", new Object[0]);
    }

    private static void toggleLookedAtSmoothable() {
        BlockState[] blockStateArray;
        boolean newValue;
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel world = minecraft.f_91073_;
        LocalPlayer player = minecraft.f_91074_;
        HitResult lookingAt = minecraft.f_91077_;
        if (world == null || player == null || lookingAt == null || lookingAt.m_6662_() != HitResult.Type.BLOCK) {
            LOG.debug("toggleLookedAtSmoothable preconditions not met (world={}, player={}, lookingAt={})", (Object)world, (Object)player, (Object)lookingAt);
            return;
        }
        BlockHitResult targeted = (BlockHitResult)lookingAt;
        BlockState targetedState = world.m_8055_(targeted.m_82425_());
        boolean bl = newValue = !NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)targetedState);
        if (player.m_6144_()) {
            BlockState[] blockStateArray2 = new BlockState[1];
            blockStateArray = blockStateArray2;
            blockStateArray2[0] = targetedState;
        } else {
            blockStateArray = (BlockState[])ModUtil.getStates(targetedState.m_60734_()).toArray(BlockState[]::new);
        }
        BlockState[] states = blockStateArray;
        LOG.debug("toggleLookedAtSmoothable currentServerHasNoCubes={}", (Object)NoCubesNetwork.currentServerHasNoCubes);
        if (!NoCubesNetwork.currentServerHasNoCubes) {
            NoCubes.smoothableHandler.setSmoothable(newValue, (BlockBehaviour.BlockStateBase[])states);
            RenderHelper.reloadAllChunks("toggleLookedAtSmoothable was pressed while connected to a server that doesn't have NoCubes installed", new Object[0]);
        } else if (C2SRequestUpdateSmoothable.checkPermissionAndNotifyIfUnauthorised((Player)player, (MinecraftServer)minecraft.m_91092_())) {
            NoCubesNetwork.CHANNEL.sendToServer((Object)new C2SRequestUpdateSmoothable(newValue, states));
        }
    }
}

