/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.hooks.SelfCheck;
import io.github.cadiboo.nocubes.network.NoCubesNetwork;
import io.github.cadiboo.nocubes.util.ModUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.Connection;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class ClientEventSubscriber {
    private static final Logger LOG = LogManager.getLogger();
    private static long selfCheckInfoPrintedAt = Long.MIN_VALUE;

    @SubscribeEvent
    public static void printDebugInfo(TickEvent.ClientTickEvent event) {
        if (!NoCubesConfig.Client.debugEnabled || !Screen.m_96639_()) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        long time = world.m_46467_();
        if (time - 200L <= selfCheckInfoPrintedAt) {
            return;
        }
        selfCheckInfoPrintedAt = time;
        LogManager.getLogger((String)"NoCubes Hooks SelfCheck").info(String.join((CharSequence)"\n", SelfCheck.info()));
    }

    @SubscribeEvent
    public static void onClientJoinServer(ClientPlayerNetworkEvent.LoggingIn event) {
        LOG.debug("Client joined server");
        ClientEventSubscriber.loadDefaultServerConfigIfWeAreOnAVanillaServer(event);
        ClientEventSubscriber.disableCollisionsIfServerDoesNotHaveNoCubes(event);
    }

    public static void disableCollisionsIfServerDoesNotHaveNoCubes(ClientPlayerNetworkEvent.LoggingIn event) {
        if (NoCubesNetwork.currentServerHasNoCubes || !NoCubesConfig.Server.collisionsEnabled) {
            return;
        }
        NoCubesConfig.Server.collisionsEnabled = false;
        ModUtil.warnPlayer((Player)event.getPlayer(), "nocubes.notification.nocubesNotInstalledOnServerCollisionsUnavailable", new Object[0]);
    }

    public static void loadDefaultServerConfigIfWeAreOnAVanillaServer(ClientPlayerNetworkEvent.LoggingIn event) {
        if (NoCubesNetwork.currentServerHasNoCubes) {
            LOG.debug("Not loading default server config - current server has NoCubes installed");
            return;
        }
        Connection connection = event.getConnection();
        if (connection != null && NetworkHooks.isVanillaConnection((Connection)connection)) {
            LOG.debug("Not loading default server config - Forge has already loaded it for us");
            return;
        }
        if (connection == null) {
            LOG.debug("Connection was null, assuming we're connected to a modded server without NoCubes!");
        }
        LOG.debug("Connected to a modded server that doesn't have NoCubes installed, loading default server config");
        NoCubesConfig.Hacks.loadDefaultServerConfig();
    }
}

