/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes;

import io.github.cadiboo.nocubes.client.KeyMappings;
import io.github.cadiboo.nocubes.client.render.OverlayRenderers;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.network.NoCubesNetwork;
import io.github.cadiboo.nocubes.smoothable.SmoothableHandler;
import io.github.cadiboo.nocubes.util.ModUtil;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="nocubes")
public final class NoCubes {
    public static final String MOD_ID = "nocubes";
    public static final SmoothableHandler smoothableHandler = SmoothableHandler.create();

    public NoCubes() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        NoCubesConfig.register(ModLoadingContext.get(), modBus);
        if (FMLEnvironment.dist.isClient()) {
            modBus.addListener(event -> KeyMappings.register(event, MinecraftForge.EVENT_BUS));
        }
        NoCubesNetwork.register();
        modBus.addListener(event -> OverlayRenderers.register(MinecraftForge.EVENT_BUS));
    }

    public static boolean isSmoothable(BlockState state) {
        return smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)state);
    }

    public static void addSmoothable(Block ... blocks) {
        for (Block block : blocks) {
            NoCubes.addSmoothable((BlockState[])ModUtil.getStates(block).toArray((Object[])new BlockState[0]));
        }
    }

    public static void addSmoothable(BlockState ... states) {
        NoCubesConfig.Smoothables.addDefault(states);
    }
}

