/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.conjurer_illager.world;

import com.legacy.conjurer_illager.IllagerRegistry;
import com.legacy.conjurer_illager.MLSupporter;
import com.legacy.conjurer_illager.TheConjurerMod;
import com.legacy.conjurer_illager.entity.ConjurerEntity;
import com.legacy.conjurer_illager.registry.IllagerEntityTypes;
import com.legacy.conjurer_illager.registry.IllagerStructures;
import com.legacy.structure_gel.api.structure.jigsaw.AbstractGelStructurePiece;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class TheaterStructure {

    public static class Piece
    extends AbstractGelStructurePiece {
        private static final Field directionField = ObfuscationReflectionHelper.findField(HangingEntity.class, (String)"f_31699_");

        public Piece(StructureTemplateManager template, StructurePoolElement jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, BoundingBox boundingBox) {
            super(template, jigsawPiece, pos, groundLevelDelta, rotation, boundingBox);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super(context, nbt);
        }

        public void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor worldIn, RandomSource rand, BoundingBox bounds) {
            if (key.equals("conjurer")) {
                this.setAir((LevelAccessor)worldIn, pos);
                ConjurerEntity entity = (ConjurerEntity)this.createEntity(IllagerEntityTypes.CONJURER, worldIn, pos, this.f_72599_);
                entity.m_6518_(worldIn, worldIn.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                entity.m_21530_();
                worldIn.m_7967_((Entity)entity);
            } else if (key.equals("admissioner")) {
                this.setAir((LevelAccessor)worldIn, pos);
                Pillager entity = (Pillager)this.createEntity(EntityType.f_20513_, worldIn, pos, this.f_72599_);
                entity.m_6518_(worldIn, worldIn.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                entity.m_21530_();
                worldIn.m_7967_((Entity)entity);
            } else if (key.equals("villager")) {
                this.setAir((LevelAccessor)worldIn, pos);
                Villager entity = (Villager)this.createEntity(EntityType.f_20492_, worldIn, pos, this.f_72599_);
                entity.m_6518_(worldIn, worldIn.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                worldIn.m_7967_((Entity)entity);
                entity.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)entity, ConjurerEntity.class, 15.0f, 2.0f));
            } else if (key.equals("audience")) {
                this.setAir((LevelAccessor)worldIn, pos);
                Mob entity = (Mob)this.createEntity(EntityType.f_20513_, worldIn, pos, this.f_72599_);
                if (rand.m_188501_() < 0.05f) {
                    entity = (Mob)this.createEntity(EntityType.f_20459_, worldIn, pos, this.f_72599_);
                } else if (rand.m_188501_() < 0.4f) {
                    entity = (Mob)this.createEntity(EntityType.f_20493_, worldIn, pos, this.f_72599_);
                } else if (rand.m_188501_() < 0.2f) {
                    entity = (Mob)this.createEntity(EntityType.f_20495_, worldIn, pos, this.f_72599_);
                }
                entity.m_6518_(worldIn, worldIn.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                entity.m_21530_();
                worldIn.m_7967_((Entity)entity);
                entity.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal(entity, ConjurerEntity.class, 15.0f, 2.0f));
            } else if (key.contains("lectern")) {
                this.setAir((LevelAccessor)worldIn, pos);
                ItemStack bookStack = new ItemStack((ItemLike)Items.f_42615_);
                CompoundTag bookNBT = bookStack.m_41784_();
                ListTag bookPages = new ListTag();
                Object pageText = "VIP Admission List\n -=-=-=-=-=-=-=-=-\n";
                String[] names = (String[])TheConjurerMod.SUPPORTERS.getSupporters().values().stream().filter(mls -> mls.rank == MLSupporter.Rank.DEV || mls.rank == MLSupporter.Rank.SUPPORTER).map(mls -> mls.name).toArray(String[]::new);
                if (names.length > 0) {
                    for (int i = 0; i < 12; ++i) {
                        String name = names[rand.m_188503_(names.length)];
                        pageText = (String)pageText + name + "\n";
                        names = (String[])Arrays.asList(names).stream().filter(s -> s != name).toArray(String[]::new);
                    }
                    bookPages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)pageText))));
                    bookNBT.m_128359_("title", "Admission List");
                    bookNBT.m_128359_("author", "The Conjurer");
                    bookNBT.m_128365_("pages", (Tag)bookPages);
                    bookStack.m_41751_(bookNBT);
                    LecternBlockEntity lectern = (LecternBlockEntity)worldIn.m_7702_(pos.m_7495_());
                    lectern.m_59536_(bookStack);
                }
            } else if (key.equals("fish")) {
                worldIn.m_7731_(pos, Blocks.f_50062_.m_49966_(), 3);
                TropicalFish entity = (TropicalFish)this.createEntity(EntityType.f_20489_, worldIn, pos.m_6630_(rand.m_188503_(3) + 1), this.f_72599_);
                entity.m_6518_(worldIn, worldIn.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                entity.m_21530_();
                worldIn.m_7967_((Entity)entity);
            } else if (key.contains("chest")) {
                String[] data = key.split("-");
                Direction facing = Direction.m_122402_((String)data[1]);
                worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                worldIn.m_7731_(pos, ((BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)facing)).rotate((LevelAccessor)worldIn, pos, this.f_72599_), 3);
            } else if (key.contains("art")) {
                String[] data = key.split("-");
                Direction facing = Direction.m_122402_((String)data[1]);
                this.setAir((LevelAccessor)worldIn, pos);
                Painting entity = (Painting)this.createEntity(EntityType.f_20506_, worldIn, pos, this.f_72599_);
                Optional painting = ForgeRegistries.PAINTING_VARIANTS.getHolder((Object)IllagerRegistry.THEATER_PAINTING);
                if (painting.isPresent()) {
                    entity.m_218891_((Holder)painting.get());
                }
                try {
                    directionField.set(entity, this.f_72599_.m_55954_(facing));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                worldIn.m_7967_((Entity)entity);
            } else if (key.contains("mirror")) {
                String[] data = key.split("-");
                Direction facing = Direction.m_122402_((String)data[1]);
                this.setAir((LevelAccessor)worldIn, pos);
                ItemFrame entity = (ItemFrame)this.createEntity(EntityType.f_20462_, worldIn, pos, this.f_72599_);
                entity.m_31805_(Items.f_42027_.m_5456_().m_7968_());
                try {
                    directionField.set(entity, this.f_72599_.m_55954_(facing));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                worldIn.m_7967_((Entity)entity);
            }
        }

        public StructurePieceType m_210000_() {
            return (StructurePieceType)IllagerStructures.THEATER.getPieceType().get();
        }
    }
}

