/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.conjurer_illager.entity;

import com.legacy.conjurer_illager.entity.BouncingBallEntity;
import com.legacy.conjurer_illager.entity.ThrowingCardEntity;
import com.legacy.conjurer_illager.registry.IllagerEntityTypes;
import com.legacy.conjurer_illager.registry.IllagerParticles;
import com.legacy.conjurer_illager.registry.IllagerSounds;
import com.legacy.conjurer_illager.registry.IllagerStructures;
import com.legacy.structure_gel.api.entity.EntityAccessHelper;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ConjurerEntity
extends SpellcasterIllager {
    private static final Vec3i BOUNCY_BALL_SPELL_COLOR = new Vec3i(243, 162, 43);
    private static final Vec3i RABBIT_SPELL_COLOR = new Vec3i(255, 208, 208);
    private static final Vec3i DISPLACE_SPELL_COLOR = new Vec3i(165, 96, 201);
    private static final Vec3i DISAPPEAR_SPELL_COLOR = new Vec3i(77, 77, 204);
    public int throwingCardCooldown = 0;

    public ConjurerEntity(EntityType<? extends ConjurerEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 15;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new CastingSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new DisappearSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new ThrowingCardAttackGoal());
        this.f_21345_.m_25352_(5, (Goal)new BouncyBallSpellGoal());
        this.f_21345_.m_25352_(6, (Goal)new BunnySpellGoal());
        this.f_21345_.m_25352_(6, (Goal)new DisplaceSpellGoal());
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 2.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                List nearbyRaiders = this.f_26135_.f_19853_.m_45976_(Raider.class, new AABB(this.f_26135_.m_20183_()).m_82377_(20.0, 10.0, 20.0));
                return super.m_8036_() && nearbyRaiders.size() <= 2;
            }
        }.m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal<Player>((PathfinderMob)this, Player.class, 7.0f, 0.6, 1.0){

            public boolean m_8036_() {
                List nearbyRaiders = this.f_25015_.f_19853_.m_45976_(Raider.class, new AABB(this.f_25015_.m_20183_()).m_82377_(20.0, 10.0, 20.0));
                return super.m_8036_() && (nearbyRaiders.size() <= 2 || this.f_25015_.m_5448_() != null);
            }
        });
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22276_, 120.0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        ServerLevel sl;
        boolean inTheatre;
        if (level instanceof ServerLevel && (!(inTheatre = (sl = (ServerLevel)level).m_215010_().m_220491_(this.m_20183_(), IllagerStructures.THEATERS).m_73603_()) || reason != MobSpawnType.STRUCTURE || (reason == MobSpawnType.SPAWN_EGG || reason == MobSpawnType.COMMAND) && inTheatre)) {
            this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        }
        return super.m_6518_(level, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.m_33736_()) {
            float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            float f1 = Mth.m_14089_((float)f);
            float f2 = Mth.m_14031_((float)f);
            if (this.f_19797_ % 4 == 0) {
                double r = this.f_19796_.m_188583_() * 0.03;
                double g = 0.08;
                double b = this.f_19796_.m_188583_() * 0.03;
                SimpleParticleType particle = this.f_19796_.m_188499_() ? IllagerParticles.BLACK_PLAYING_CARD : IllagerParticles.RED_PLAYING_CARD;
                this.f_19853_.m_7106_((ParticleOptions)particle, this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)f2 * 0.6, r, g, b);
                this.f_19853_.m_7106_((ParticleOptions)particle, this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)f2 * 0.6, r, g, b);
            }
            double d0 = (double)this.getSpellColors().m_123341_() / 255.0;
            double d1 = (double)this.getSpellColors().m_123342_() / 255.0;
            double d2 = (double)this.getSpellColors().m_123343_() / 255.0;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)f2 * 0.6, d0, d1, d2);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)f2 * 0.6, d0, d1, d2);
        }
        if (this.throwingCardCooldown > 0) {
            --this.throwingCardCooldown;
        }
    }

    private Vec3i getSpellColors() {
        SpellcasterIllager.IllagerSpell spellType = this.m_33737_();
        if (spellType == SpellcasterIllager.IllagerSpell.FANGS) {
            return BOUNCY_BALL_SPELL_COLOR;
        }
        if (spellType == SpellcasterIllager.IllagerSpell.SUMMON_VEX) {
            return RABBIT_SPELL_COLOR;
        }
        if (spellType == SpellcasterIllager.IllagerSpell.WOLOLO) {
            return DISPLACE_SPELL_COLOR;
        }
        if (spellType == SpellcasterIllager.IllagerSpell.DISAPPEAR) {
            return DISAPPEAR_SPELL_COLOR;
        }
        return Vec3i.f_123288_;
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = 0.25;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                SimpleParticleType particle = this.f_19796_.m_188499_() ? IllagerParticles.BLACK_PLAYING_CARD : IllagerParticles.RED_PLAYING_CARD;
                this.f_19853_.m_7106_((ParticleOptions)particle, this.m_20165_(1.0) - d0 * 10.0, this.m_20187_() - d1 * 10.0 + 1.0, this.m_20262_(1.0) - d2 * 10.0, d0, d1, d2);
            }
        }
    }

    public boolean m_7307_(Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (entityIn == this) {
            return true;
        }
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof Vex) {
            return this.m_7307_((Entity)((Vex)entityIn).m_34026_());
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f + 0.9f;
    }

    protected SoundEvent m_7515_() {
        return IllagerSounds.ENTITY_CONJURER_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return IllagerSounds.ENTITY_CONJURER_HURT;
    }

    protected SoundEvent m_5592_() {
        return IllagerSounds.ENTITY_CONJURER_DEATH;
    }

    protected SoundEvent m_7894_() {
        return IllagerSounds.ENTITY_CONJURER_CAST_SPELL;
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public SoundEvent m_7930_() {
        return IllagerSounds.ENTITY_CONJURER_CELEBRATE;
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_21205_().m_41720_() == Items.f_42516_) {
            return AbstractIllager.IllagerArmPose.CROSSBOW_HOLD;
        }
        return super.m_6768_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return source == DamageSource.f_19317_ ? super.m_6469_(source, amount) : (source.m_19390_() ? super.m_6469_(source, amount) : super.m_6469_(source, Math.min(15.0f, amount)));
    }

    public boolean isEntityLooking(LivingEntity entity) {
        if (entity != null) {
            Vec3 vec3d = entity.m_20252_(1.0f).m_82541_();
            Vec3 vec3d1 = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20191_().f_82289_ + (double)this.m_20192_() - (entity.m_20186_() + (double)entity.m_20192_()), this.m_20189_() - entity.m_20189_());
            double d0 = vec3d1.m_82553_();
            double d1 = vec3d.m_82526_(vec3d1 = vec3d1.m_82541_());
            return !(d1 < 1.0 / d0);
        }
        return false;
    }

    class CastingSpellGoal
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        private final ConjurerEntity conjurer;

        private CastingSpellGoal() {
            super((SpellcasterIllager)ConjurerEntity.this);
            this.conjurer = ConjurerEntity.this;
        }

        public void m_8037_() {
            if (this.conjurer.m_5448_() != null) {
                this.conjurer.m_21563_().m_24960_((Entity)this.conjurer.m_5448_(), (float)this.conjurer.m_8085_(), (float)this.conjurer.m_8132_());
            }
        }
    }

    class DisappearSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final ConjurerEntity conjurer;

        private DisappearSpellGoal() {
            super((SpellcasterIllager)ConjurerEntity.this);
            this.conjurer = ConjurerEntity.this;
        }

        public boolean m_8036_() {
            return this.conjurer.m_5448_() != null && (this.conjurer.f_20916_ > 0 || this.conjurer.m_20270_((Entity)this.conjurer.m_5448_()) < 8.0f) && !this.conjurer.m_21023_(MobEffects.f_19609_) && this.conjurer.isEntityLooking(this.conjurer.m_5448_()) && super.m_8036_();
        }

        protected int m_8089_() {
            return 30;
        }

        protected int m_8067_() {
            return 200;
        }

        protected void m_8130_() {
            this.conjurer.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 120 + this.conjurer.f_19853_.f_46441_.m_188503_(3) * 10, 0));
            this.conjurer.m_5496_(IllagerSounds.ENTITY_CONJURER_DISAPPEAR, 1.0f, 1.0f);
            this.conjurer.m_21373_();
            if (this.conjurer.m_5448_() == null) {
                return;
            }
            if (this.conjurer.f_19853_.f_46441_.m_188501_() <= 0.5f && this.conjurer.m_20270_((Entity)this.conjurer.m_5448_()) < 7.0f || this.conjurer.f_20916_ > 0 || this.conjurer.m_20270_((Entity)this.conjurer.m_5448_()) <= 4.0f) {
                this.conjurer.m_7678_(this.conjurer.m_5448_().m_20185_(), this.conjurer.m_5448_().m_20186_(), this.conjurer.m_5448_().m_20189_(), this.conjurer.m_5448_().m_6080_(), this.conjurer.m_5448_().m_146909_());
                this.conjurer.m_19920_(2.0f, new Vec3(0.0, 0.0, -4.0));
            }
        }

        protected SoundEvent m_7030_() {
            return IllagerSounds.ENTITY_CONJURER_PREPARE_VANISH;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.DISAPPEAR;
        }
    }

    class ThrowingCardAttackGoal
    extends Goal {
        private final ConjurerEntity conjurer;
        public int cardThrows;

        private ThrowingCardAttackGoal() {
            this.conjurer = ConjurerEntity.this;
            this.cardThrows = 0;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.conjurer.throwingCardCooldown <= 0 && this.cardThrows < 10 && !this.conjurer.m_33736_() && this.conjurer.m_5448_() != null && this.conjurer.m_5448_().f_19853_.f_46441_.m_188503_(20) == 0;
        }

        public void m_8041_() {
            super.m_8041_();
            this.cardThrows = 0;
            this.conjurer.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }

        public boolean m_8045_() {
            return this.conjurer.m_5448_() != null && !this.conjurer.m_33736_() && this.cardThrows < 10;
        }

        public void m_8056_() {
            super.m_8056_();
            this.conjurer.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42516_));
        }

        public void m_8037_() {
            super.m_8037_();
            ConjurerEntity conjurer = this.conjurer;
            if (conjurer.f_19797_ % 4 == 0 && this.cardThrows < 10) {
                conjurer.m_6674_(InteractionHand.MAIN_HAND);
                ++this.cardThrows;
                double x = this.conjurer.m_5448_().m_20185_() - this.conjurer.m_20185_();
                double y = this.conjurer.m_5448_().m_20191_().f_82289_ + (double)(this.conjurer.m_5448_().m_20206_() / 2.0f) - (this.conjurer.m_20186_() + (double)(this.conjurer.m_20206_() / 2.0f));
                double z = this.conjurer.m_5448_().m_20189_() - this.conjurer.m_20189_();
                Vec3 lookVector = this.conjurer.m_20252_(1.0f);
                ThrowingCardEntity projectile = new ThrowingCardEntity(IllagerEntityTypes.THROWING_CARD, (LivingEntity)this.conjurer, this.conjurer.f_19853_);
                RandomSource rand = this.conjurer.f_19853_.f_46441_;
                projectile.m_6686_(x, y, z, 1.2f, 0.5f);
                projectile.m_6034_(this.conjurer.m_20185_() + lookVector.f_82479_ * 1.0, this.conjurer.m_20186_() + (double)(this.conjurer.m_20206_() / 2.0f) + (double)0.2f, this.conjurer.m_20189_() + lookVector.f_82481_ * 1.0);
                conjurer.m_5496_(SoundEvents.f_11713_, 1.0f, 1.0f);
                projectile.setCardType(rand.m_188501_() < 0.1f ? 2 : rand.m_188503_(2));
                if (!this.conjurer.f_19853_.f_46443_) {
                    this.conjurer.f_19853_.m_7967_((Entity)projectile);
                }
                if (this.cardThrows == 9) {
                    this.conjurer.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    conjurer.throwingCardCooldown = 200;
                }
            }
            if (this.conjurer.m_5448_() != null) {
                this.conjurer.m_21563_().m_24960_((Entity)this.conjurer.m_5448_(), (float)this.conjurer.m_8085_(), (float)this.conjurer.m_8132_());
            }
        }

        public boolean m_6767_() {
            return false;
        }
    }

    class BouncyBallSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final ConjurerEntity conjurer;

        private BouncyBallSpellGoal() {
            super((SpellcasterIllager)ConjurerEntity.this);
            this.conjurer = ConjurerEntity.this;
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }

        protected int m_8089_() {
            return 40;
        }

        protected int m_8067_() {
            return 220;
        }

        protected void m_8130_() {
            double x = this.conjurer.m_5448_().m_20185_() - this.conjurer.m_20185_();
            double y = this.conjurer.m_5448_().m_20191_().f_82289_ + (double)(this.conjurer.m_5448_().m_20206_() / 2.0f) - (this.conjurer.m_20186_() + (double)(this.conjurer.m_20206_() / 2.0f));
            double z = this.conjurer.m_5448_().m_20189_() - this.conjurer.m_20189_();
            Vec3 lookVector = this.conjurer.m_20252_(1.0f);
            for (int i = 0; i < 5; ++i) {
                BouncingBallEntity projectile = new BouncingBallEntity(IllagerEntityTypes.BOUNCING_BALL, (LivingEntity)this.conjurer, this.conjurer.f_19853_);
                RandomSource rand = this.conjurer.f_19853_.f_46441_;
                projectile.m_20242_(!this.conjurer.f_19853_.m_45527_(this.conjurer.m_20183_()));
                projectile.m_6686_(x + (double)(i * 5) - 10.0, y + (double)rand.m_188503_(3), z, 0.5f, 1.0f);
                projectile.m_6034_(this.conjurer.m_20185_() + lookVector.f_82479_ * 1.0, this.conjurer.m_20186_() + (double)(this.conjurer.m_20206_() / 2.0f) + (double)0.2f, this.conjurer.m_20189_() + lookVector.f_82481_ * 1.0);
                projectile.setBallType(rand.m_188503_(5));
                if (this.conjurer.f_19853_.f_46443_) continue;
                this.conjurer.f_19853_.m_7967_((Entity)projectile);
            }
        }

        protected SoundEvent m_7030_() {
            return IllagerSounds.ENTITY_CONJURER_PREPARE_ATTACK;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }

    class BunnySpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final ConjurerEntity conjurer;

        private BunnySpellGoal() {
            super((SpellcasterIllager)ConjurerEntity.this);
            this.conjurer = ConjurerEntity.this;
        }

        public boolean m_8036_() {
            List nearbyRabbits = this.conjurer.f_19853_.m_45976_(Rabbit.class, new AABB(this.conjurer.m_20183_()).m_82377_(25.0, 15.0, 25.0));
            if (!super.m_8036_() || this.conjurer.m_5448_() == null || this.conjurer.m_21023_(MobEffects.f_19609_)) {
                return false;
            }
            return super.m_8036_() && nearbyRabbits.size() < 3;
        }

        protected int m_8089_() {
            return 50;
        }

        protected int m_8067_() {
            return 300;
        }

        protected void m_8130_() {
            Vec3 lookVector = this.conjurer.m_20252_(1.0f);
            double x = this.conjurer.m_20185_() + lookVector.f_82479_;
            double y = this.conjurer.m_20186_() + ((double)(this.conjurer.m_20206_() / 2.0f) + 2.0);
            double z = this.conjurer.m_20189_() + lookVector.f_82481_;
            BlockPos blockpos = new BlockPos(x, y, z);
            Rabbit rabbit = (Rabbit)EntityType.f_20517_.m_20615_(this.conjurer.f_19853_);
            rabbit.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)rabbit, 1.4, true));
            rabbit.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)rabbit, new Class[0]));
            rabbit.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)rabbit, Player.class, true));
            rabbit.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)rabbit, Villager.class, true));
            rabbit.m_21051_(Attributes.f_22284_).m_22100_(8.0);
            rabbit.m_21051_(Attributes.f_22276_).m_22100_(10.0);
            rabbit.m_21051_(Attributes.f_22279_).m_22100_(0.45);
            rabbit.m_6710_(this.conjurer.m_5448_());
            EntityAccessHelper.setDeathLootTable((Mob)rabbit, (ResourceLocation)BuiltInLootTables.f_78712_);
            rabbit.m_29733_(ConjurerEntity.this.f_19796_.m_188499_() ? 3 : 1);
            rabbit.m_20334_(rabbit.m_20184_().m_7096_(), (double)0.3f, rabbit.m_20184_().m_7094_());
            rabbit.m_20035_(blockpos, this.conjurer.f_20885_, this.conjurer.m_146909_());
            rabbit.m_19920_(0.3f, new Vec3(0.0, 0.0, 1.0));
            rabbit.m_21153_(10.0f);
            if (!rabbit.m_7307_((Entity)this.conjurer) && this.conjurer.m_5647_() != null) {
                this.conjurer.f_19853_.m_6188_().m_6546_(rabbit.m_20148_().toString(), this.conjurer.f_19853_.m_6188_().m_83489_(this.conjurer.m_5647_().m_5758_()));
            }
            this.conjurer.f_19853_.m_7967_((Entity)rabbit);
        }

        protected SoundEvent m_7030_() {
            return IllagerSounds.ENTITY_CONJURER_PREPARE_RABBIT;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }

    class DisplaceSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final ConjurerEntity conjurer;

        private DisplaceSpellGoal() {
            super((SpellcasterIllager)ConjurerEntity.this);
            this.conjurer = ConjurerEntity.this;
        }

        public boolean m_8036_() {
            if (this.conjurer.m_5448_() != null && this.conjurer.m_21023_(MobEffects.f_19609_)) {
                return super.m_8036_();
            }
            return false;
        }

        protected int m_8089_() {
            return 60;
        }

        protected int m_8067_() {
            return 460;
        }

        protected void m_8130_() {
            LivingEntity entityLiving = this.conjurer.m_5448_();
            this.teleportEntity(entityLiving, true);
        }

        public void teleportEntity(LivingEntity entityLiving, boolean strictIn) {
            Level worldIn = entityLiving.f_19853_;
            double d0 = entityLiving.m_20185_();
            double d1 = entityLiving.m_20186_();
            double d2 = entityLiving.m_20189_();
            for (int i = 0; i < 30; ++i) {
                BlockPos pos;
                double d3 = entityLiving.m_20185_() + (entityLiving.m_217043_().m_188500_() - 0.5) * 16.0;
                double d4 = Mth.m_14008_((double)(entityLiving.m_20186_() + (double)(entityLiving.m_217043_().m_188503_(5) - 2)), (double)0.0, (double)(worldIn.m_151558_() - 1));
                double d5 = entityLiving.m_20189_() + (entityLiving.m_217043_().m_188500_() - 0.5) * 16.0;
                if (entityLiving.m_20159_()) {
                    entityLiving.m_8127_();
                }
                boolean isProperBlock = !this.conjurer.f_19853_.m_45527_(this.conjurer.m_20183_()) ? (strictIn ? worldIn.m_8055_((pos = new BlockPos(d3, d4, d5)).m_7495_()).m_60734_() == Blocks.f_50742_ || worldIn.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50009_ || worldIn.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50049_ || worldIn.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50270_ : !worldIn.m_46861_(new BlockPos(d3, d4, d5))) : true;
                if (!isProperBlock || !entityLiving.m_20984_(d3, d4, d5, true)) continue;
                worldIn.m_6263_((Player)null, d0, d1, d2, SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
                entityLiving.m_5496_(SoundEvents.f_11757_, 1.0f, 1.0f);
                break;
            }
        }

        protected SoundEvent m_7030_() {
            return IllagerSounds.ENTITY_CONJURER_PREPARE_DISPLACEMENT;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }
}

