/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui;

import info.u_team.music_player.gui.BetterScrollableListEntry;
import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.GuiMusicPlayerList;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylist;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.LoadedTracks;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.musicplayer.playlist.Playlists;
import info.u_team.music_player.musicplayer.playlist.Skip;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.ImageToggleButton;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import org.apache.commons.lang3.tuple.Pair;

class GuiMusicPlayerListEntry
extends BetterScrollableListEntry<GuiMusicPlayerListEntry> {
    private final Playlists playlists;
    private final Playlist playlist;
    private final ImageToggleButton playPlaylistButton;
    private final ImageButton openPlaylistButton;
    private final ImageButton deletePlaylistButton;

    public GuiMusicPlayerListEntry(GuiMusicPlayerList gui, Playlists playlists, Playlist playlist) {
        this.playlists = playlists;
        this.playlist = playlist;
        this.playPlaylistButton = (ImageToggleButton)this.addChildren((class_364)new ImageToggleButton(0, 0, 20, 20, MusicPlayerResources.TEXTURE_PLAY, MusicPlayerResources.TEXTURE_STOP, playlist.equals(playlists.getPlaying())));
        this.playPlaylistButton.field_22763 = !playlists.isPlayingLock();
        this.playPlaylistButton.setPressable(() -> {
            boolean play = this.playPlaylistButton.isToggled();
            if (playlists.isPlayingLock()) {
                return;
            }
            playlists.setPlaying(null);
            gui.method_25396().stream().filter(entry -> entry != this).forEach(entry -> entry.playPlaylistButton.setToggled(false));
            Runnable runnable = () -> {
                ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
                if (play) {
                    if (!playlist.isEmpty()) {
                        playlists.setPlaying(playlist);
                        Pair<LoadedTracks, IAudioTrack> pair = playlist.getFirstTrack();
                        playlist.setPlayable((LoadedTracks)pair.getLeft(), (IAudioTrack)pair.getRight());
                        if (((LoadedTracks)pair.getLeft()).hasError() || pair.getRight() == null) {
                            playlist.skip(Skip.FORWARD);
                        }
                        manager.setTrackQueue(playlist);
                        manager.start();
                    } else {
                        playlists.setPlaying(null);
                        playlist.setStopable();
                        manager.stop();
                        this.playPlaylistButton.setToggled(false);
                    }
                } else {
                    playlists.setPlaying(null);
                    playlist.setStopable();
                    manager.stop();
                }
                playlists.removePlayingLock();
                class_437 patt3292$temp = this.minecraft.field_1755;
                if (patt3292$temp instanceof GuiMusicPlayer) {
                    GuiMusicPlayer musicplayergui = (GuiMusicPlayer)patt3292$temp;
                    GuiMusicPlayerList newGui = musicplayergui.getPlaylistsList();
                    newGui.method_25396().forEach(entry -> {
                        entry.playPlaylistButton.field_22763 = true;
                    });
                } else {
                    class_437 patt3526$temp = this.minecraft.field_1755;
                    if (patt3526$temp instanceof GuiMusicPlaylist) {
                        GuiMusicPlaylist musicplaylistgui = (GuiMusicPlaylist)patt3526$temp;
                        musicplaylistgui.getTrackList().updateAllEntries();
                    }
                }
            };
            gui.method_25396().forEach(entry -> {
                entry.playPlaylistButton.field_22763 = false;
            });
            playlists.setPlayingLock();
            if (!playlist.isLoaded()) {
                playlist.load(runnable);
            } else {
                runnable.run();
            }
        });
        this.openPlaylistButton = (ImageButton)this.addChildren((class_364)new ImageButton(0, 0, 20, 20, MusicPlayerResources.TEXTURE_OPEN));
        this.openPlaylistButton.setPressable(() -> this.minecraft.method_1507((class_437)new GuiMusicPlaylist(playlist)));
        this.deletePlaylistButton = (ImageButton)this.addChildren((class_364)new ImageButton(0, 0, 20, 20, MusicPlayerResources.TEXTURE_CLEAR));
        this.deletePlaylistButton.setPressable(() -> gui.removePlaylist(this));
    }

    public void method_25343(class_4587 matrixStack, int slotIndex, int entryY, int entryX, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        Object name = this.playlist.getName();
        if (((String)name).isEmpty()) {
            name = "\u00a7o" + MusicPlayerLocalization.getTranslation("gui.musicplayer.playlists.no_name", new Object[0]);
        }
        this.minecraft.field_1772.method_1729(matrixStack, (String)name, (float)(entryX + 5), (float)(entryY + 5), this.playlist.equals(this.playlists.getPlaying()) ? 33791 : 0xFFF00F);
        this.minecraft.field_1772.method_1729(matrixStack, this.playlist.getEntrySize() + " " + MusicPlayerLocalization.getTranslation(this.playlist.getEntrySize() > 1 ? "gui.musicplayer.playlists.entries" : "gui.musicplayer.playlists.entry", new Object[0]), (float)(entryX + 5), (float)(entryY + 30), 0xFFFFFF);
        this.playPlaylistButton.field_22760 = entryWidth - 65;
        this.playPlaylistButton.field_22761 = entryY + 12;
        this.playPlaylistButton.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.openPlaylistButton.field_22760 = entryWidth - 40;
        this.openPlaylistButton.field_22761 = entryY + 12;
        this.openPlaylistButton.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.deletePlaylistButton.field_22760 = entryWidth - 15;
        this.deletePlaylistButton.field_22761 = entryY + 12;
        this.deletePlaylistButton.method_25394(matrixStack, mouseX, mouseY, partialTicks);
    }

    public Playlist getPlaylist() {
        return this.playlist;
    }

    public class_2561 method_37006() {
        return class_5244.field_39003;
    }
}

