/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.util.RandomUtil;

public final class PositionAndMotionUtil {
    public static Vec3 accountForGravity(Vec3 origin, Vec3 velocity, Vec3 targetPos, double gravity) {
        double vel = Vec3.f_82478_.m_82554_(velocity);
        double ticksToTravel = origin.m_82554_(targetPos) / vel;
        double accumulatedGravity = gravity * Math.ceil(ticksToTravel) / (vel * vel);
        return velocity.m_82520_(0.0, accumulatedGravity / Math.pow(0.987, Math.floor(ticksToTravel)), 0.0);
    }

    public static void turnToFace(Entity entity, Vec3 targetPosition) {
        Vec3 position = entity.m_146892_();
        double lengthX = targetPosition.m_7096_() - position.m_7096_();
        double lengthY = targetPosition.m_7098_() - position.m_7098_();
        double lengthZ = targetPosition.m_7094_() - position.m_7094_();
        entity.m_146926_((float)Math.toDegrees(Mth.m_14136_((double)lengthZ, (double)lengthX)) - 90.0f);
        entity.m_146922_((float)Math.toDegrees(-Mth.m_14136_((double)lengthY, (double)Math.sqrt(lengthX * lengthX + lengthZ * lengthZ))));
        entity.f_19860_ = entity.m_146909_();
        entity.f_19859_ = entity.m_146908_();
    }

    public static void faceTowardsMotion(Entity entity) {
        Vec3 velocity = entity.m_20184_();
        entity.m_146922_((float)Math.toDegrees(Mth.m_14136_((double)velocity.m_7096_(), (double)velocity.m_7094_())));
        entity.m_146926_((float)Math.toDegrees(Mth.m_14136_((double)velocity.m_7098_(), (double)velocity.m_165924_())));
        entity.f_19859_ = entity.m_146908_();
        entity.f_19860_ = entity.m_146909_();
    }

    public static void moveTowards(Entity entity, Vec3 targetPosition, double blocksPerSecond, double inaccuracy) {
        PositionAndMotionUtil.moveTowards(entity, targetPosition, blocksPerSecond, (double)0.0075f * inaccuracy, (double)0.0075f * inaccuracy);
    }

    public static void moveTowards(Entity entity, Vec3 targetPosition, double blocksPerSecond, double lateralVariance, double verticalVariance) {
        Vec3 origin = entity.m_20182_();
        Vec3 velocity = new Vec3(targetPosition.m_7096_() - origin.m_7096_(), targetPosition.m_7098_() - origin.m_7098_(), targetPosition.m_7094_() - origin.m_7094_()).m_82541_();
        if (lateralVariance != 0.0 || verticalVariance != 0.0) {
            velocity = velocity.m_82520_(RandomUtil.randomScaledGaussianValue(lateralVariance), RandomUtil.randomScaledGaussianValue(verticalVariance), RandomUtil.randomScaledGaussianValue(lateralVariance));
        }
        entity.m_20256_(velocity.m_82490_(blocksPerSecond));
    }

    public static void moveRelativeToFacing(Entity entity, double moveLeft, double moveForward, double moveUp) {
        double radians = Math.toRadians(entity.m_146908_() - 180.0f);
        entity.m_6034_(entity.m_20185_() + moveLeft * -Math.cos(radians), entity.m_20186_() + moveUp, entity.m_20189_() + moveLeft * -Math.sin(radians));
    }
}

