/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.skill;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class InnervationSkill
extends AoASkill.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.OUTGOING_ATTACK_AFTER, AoAPlayerEventListener.ListenerType.ENTITY_KILL};
    private final Int2ObjectOpenHashMap<Pair<Long, Float>> attackTracker = new Int2ObjectOpenHashMap();

    public InnervationSkill(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoASkill)AoASkills.INNERVATION.get(), plData, jsonData);
    }

    public InnervationSkill(CompoundTag nbtData) {
        super((AoASkill)AoASkills.INNERVATION.get(), nbtData);
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handlePostOutgoingAttack(LivingDamageEvent ev) {
        LivingEntity target = ev.getEntity();
        this.attackTracker.compute(target.m_19879_(), (id, value) -> {
            if (value == null) {
                return Pair.of((Object)target.f_19853_.m_46467_(), (Object)Float.valueOf(ev.getAmount()));
            }
            return Pair.of((Object)target.f_19853_.m_46467_(), (Object)Float.valueOf(Math.min(target.m_21233_() * 1.5f, ev.getAmount() + ((Float)value.getSecond()).floatValue())));
        });
    }

    @Override
    public void handleEntityKill(LivingDeathEvent ev) {
        float damageDealt;
        LivingEntity target = ev.getEntity();
        Pair attackEntry = (Pair)this.attackTracker.get(target.m_19879_());
        float f = damageDealt = attackEntry == null ? 5.0f : ((Float)attackEntry.getSecond()).floatValue();
        if (attackEntry != null) {
            this.attackTracker.remove(ev.getEntity().m_19879_());
        }
        if (this.canGainXp(true)) {
            this.adjustXp(this.getKillXpForEntity(target, damageDealt), false, false);
        }
        if (this.attackTracker.size() > 10) {
            this.purgeTracker(target.f_19853_.m_46467_());
        }
    }

    private void purgeTracker(long currentTime) {
        this.getAttackEntries().removeIf(entry -> (Long)((Pair)entry.getValue()).getFirst() < currentTime - 1200L);
    }

    public Int2ObjectMap.FastEntrySet<Pair<Long, Float>> getAttackEntries() {
        return this.attackTracker.int2ObjectEntrySet();
    }

    public boolean hasAttackedEntity(Entity entity) {
        return this.attackTracker.containsKey(entity.m_19879_());
    }

    protected float getKillXpForEntity(LivingEntity target, float damageDealt) {
        Mob mob;
        float xp = PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), (int)(Math.min(target.m_21233_() * 1.5f, damageDealt) / 16.0f * 20.0f));
        double armour = EntityUtil.safelyGetAttributeValue(target, Attributes.f_22284_);
        double toughness = armour > 0.0 ? EntityUtil.safelyGetAttributeValue(target, Attributes.f_22285_) : 0.0;
        double speed = EntityUtil.safelyGetAttributeValue(target, Attributes.f_22279_);
        xp = (float)((double)xp * (1.0 + (Math.pow(armour / 30.0, 2.0) + Math.pow(toughness / 15.0, 1.5))));
        if (target.getPersistentData().m_128441_("spawned_by_spawner")) {
            xp *= 0.25f;
        }
        if (target instanceof FlyingMob || target instanceof Mob && (mob = (Mob)target).m_21573_() instanceof WaterBoundPathNavigation) {
            xp *= 1.1f;
        }
        if (speed > (double)0.3f) {
            xp *= 1.1f;
        }
        if (!EntityUtil.isHostileMob((Entity)target)) {
            xp *= 0.5f;
        }
        if (!target.m_6072_()) {
            xp *= 1.3f;
        }
        return xp;
    }
}

