/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.skill;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class FarmingSkill
extends AoASkill.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.BLOCK_BREAK, AoAPlayerEventListener.ListenerType.ANIMAL_BREED};

    public FarmingSkill(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoASkill)AoASkills.FARMING.get(), plData, jsonData);
    }

    public FarmingSkill(CompoundTag nbtData) {
        super((AoASkill)AoASkills.FARMING.get(), nbtData);
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handleBlockBreak(BlockEvent.BreakEvent ev) {
        if (this.canGainXp(true) && BlockUtil.canPlayerHarvest(ev.getState(), ev.getPlayer(), ev.getLevel(), ev.getPos())) {
            Block block = ev.getState().m_60734_();
            int xpTime = 0;
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                xpTime = crop.m_52307_(ev.getState()) ? 7 * crop.m_7419_() : 0;
            } else if (block instanceof StemGrownBlock) {
                xpTime = 12;
            }
            if (xpTime > 0) {
                this.adjustXp(PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), xpTime), false, false);
            }
        }
    }

    @Override
    public void handleAnimalBreed(BabyEntitySpawnEvent ev) {
        if (!this.canGainXp(true)) {
            return;
        }
        this.adjustXp(PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), 600.0f), false, false);
    }
}

