/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.resource;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.resource.AoAResource;

public class SpiritResource
extends AoAResource.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.PLAYER_TICK, AoAPlayerEventListener.ListenerType.OUTGOING_ATTACK_AFTER};
    private final float maxValue;
    private final float regenPerTick;
    private final float regenPerDamage;
    private final float healthModMax;
    private float value = 0.0f;

    public SpiritResource(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoAResource)AoAResources.SPIRIT.get(), plData);
        this.maxValue = Math.max(0.0f, GsonHelper.m_13915_((JsonObject)jsonData, (String)"max_value"));
        this.regenPerTick = GsonHelper.m_13820_((JsonObject)jsonData, (String)"regen_per_tick", (float)0.04f);
        this.regenPerDamage = GsonHelper.m_13820_((JsonObject)jsonData, (String)"regen_per_damage", (float)0.75f);
        this.healthModMax = GsonHelper.m_13820_((JsonObject)jsonData, (String)"inverse_health_regen_mod", (float)2.0f);
    }

    public SpiritResource(CompoundTag nbtData) {
        super((AoAResource)AoAResources.SPIRIT.get(), null);
        this.maxValue = nbtData.m_128457_("max_value");
        this.regenPerTick = nbtData.m_128457_("regen_per_tick");
        this.regenPerDamage = nbtData.m_128457_("regen_per_damage");
        this.healthModMax = nbtData.m_128457_("inverse_health_regen_mod");
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public float getCurrentValue() {
        return this.value;
    }

    @Override
    public void setValue(float amount) {
        this.value = Mth.m_14036_((float)amount, (float)0.0f, (float)this.getMaxValue());
    }

    @Override
    public float getMaxValue() {
        return this.maxValue;
    }

    @Override
    public float getPerTickRegen() {
        return this.regenPerTick;
    }

    @Override
    public void handlePostOutgoingAttack(LivingDamageEvent ev) {
        if (this.value < this.getMaxValue() && !ev.getSource().m_19385_().equals("blaster") && !ev.getSource().m_19372_()) {
            this.addValue(this.getHealthScaledRegen(this.regenPerDamage * ev.getAmount()));
        }
    }

    @Override
    public void handlePlayerTick(TickEvent.PlayerTickEvent ev) {
        if (this.value < this.getMaxValue()) {
            this.addValue(this.getHealthScaledRegen(this.getPerTickRegen()));
        }
    }

    protected float getHealthScaledRegen(float regenAmount) {
        ServerPlayer player = this.getPlayerDataManager().player();
        return (1.0f + (1.0f - player.m_21223_() / player.m_21233_()) * (this.healthModMax - 1.0f)) * regenAmount;
    }

    @Override
    @Nonnull
    public CompoundTag saveToNbt() {
        return new CompoundTag();
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = new CompoundTag();
        if (forClientSetup) {
            data.m_128350_("max_value", this.getMaxValue());
            data.m_128350_("inverse_health_regen_mod", this.healthModMax);
            data.m_128350_("regen_per_damage", this.regenPerDamage);
            data.m_128350_("regen_per_tick", this.getPerTickRegen());
        } else {
            data.m_128350_("value", this.getCurrentValue());
        }
        return data;
    }

    @Override
    public void receiveSyncData(CompoundTag data) {
        if (data.m_128441_("value")) {
            this.value = data.m_128457_("value");
        }
    }
}

