/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.NumberUtil;

public class VulcaneDamageIncrease
extends AoAAbility.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.OUTGOING_ATTACK_DURING};
    private final float minRage;
    private final float modifier;

    public VulcaneDamageIncrease(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.VULCANE_DAMAGE_INCREASE.get(), skill, data);
        this.minRage = GsonHelper.m_13820_((JsonObject)data, (String)"min_rage", (float)0.0f);
        this.modifier = GsonHelper.m_13915_((JsonObject)data, (String)"modifier");
    }

    public VulcaneDamageIncrease(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.VULCANE_DAMAGE_INCREASE.get(), skill, data);
        this.minRage = data.m_128457_("min_rage");
        this.modifier = data.m_128457_("modifier");
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        super.updateDescription(Component.m_237110_((String)(((TranslatableContents)defaultDescription.m_214077_()).m_237508_() + (this.minRage > 0.0f ? ".minRage" : "")), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace((this.modifier - 1.0f) * 100.0f, 2), NumberUtil.roundToNthDecimalPlace(this.minRage, 2)}));
    }

    @Override
    public void handleOutgoingAttack(LivingHurtEvent ev) {
        if (DamageUtil.isVulcaneDamage(ev.getSource())) {
            ev.setAmount(ev.getAmount() * this.modifier);
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128350_("min_rage", this.minRage);
            data.m_128350_("modifier", this.modifier);
        }
        return data;
    }
}

