/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.leaderboard.task;

import java.sql.Connection;
import java.sql.SQLException;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.leaderboard.SkillsLeaderboard;
import net.tslat.aoa3.leaderboard.connection.InsertionConnection;
import net.tslat.aoa3.leaderboard.task.InsertionTask;
import net.tslat.aoa3.player.skill.AoASkill;
import org.apache.logging.log4j.Level;

public class InitializeLeaderboardTask
extends InsertionTask {
    @Override
    public void execute(Connection connection, InsertionConnection leaderboardConnection) {
        this.beginBatchUpdate(connection);
        try {
            if (((Boolean)AoAConfigs.SERVER.dontCacheDatabase.get()).booleanValue()) {
                leaderboardConnection.runStatement(connection, "SET DATABASE DEFAULT TABLE TYPE TEXT;");
            }
            leaderboardConnection.runStatement(connection, "CREATE TABLE IF NOT EXISTS Totals (Uuid NCHAR(36), Username VARCHCHAR(20), Total INT, LastUpdate DATE)");
            if (((Boolean)AoAConfigs.SERVER.dontCacheDatabase.get()).booleanValue()) {
                leaderboardConnection.runStatement(connection, "SET TABLE Totals TYPE TEXT");
            }
            for (AoASkill skill : AoARegistries.AOA_SKILLS.getAllRegisteredObjects()) {
                String tableName = InitializeLeaderboardTask.idToTableName(AoARegistries.AOA_SKILLS.getId(skill));
                leaderboardConnection.runStatement(connection, "CREATE TABLE IF NOT EXISTS " + tableName + " (Uuid NCHAR(36), Username VARCHCHAR(20), Level SMALLINT, LastUpdate DATE)");
                if (!((Boolean)AoAConfigs.SERVER.dontCacheDatabase.get()).booleanValue()) continue;
                leaderboardConnection.runStatement(connection, "SET TABLE " + tableName + " TYPE TEXT");
            }
        }
        catch (SQLException ex) {
            Logging.logMessage(Level.ERROR, "Error while initializing leaderboard tables. Shutting down leaderboard.", ex);
            SkillsLeaderboard.shutdown();
        }
        this.endBatchUpdate(connection);
    }
}

