/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.leaderboard;

import java.nio.file.Path;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.leaderboard.LeaderboardTask;
import net.tslat.aoa3.leaderboard.connection.InsertionConnection;
import net.tslat.aoa3.leaderboard.connection.LeaderboardConnection;
import net.tslat.aoa3.leaderboard.connection.RetrievalConnection;
import net.tslat.aoa3.leaderboard.task.InitializeLeaderboardTask;
import org.apache.logging.log4j.Level;
import org.hsqldb.jdbc.JDBCDriver;

public class SkillsLeaderboard {
    private static LinkedBlockingQueue<LeaderboardTask<InsertionConnection>> updateTaskQueue;
    private static LinkedBlockingQueue<LeaderboardTask<RetrievalConnection>> retrievalTaskQueue;
    private static InsertionConnection[] updateThreads;
    private static RetrievalConnection[] retrievalThreads;
    private static final AtomicBoolean enabled;
    private static String dataPath;

    public static String getConnectionPath() {
        return "jdbc:hsqldb:file:" + dataPath + "/skills";
    }

    public static LinkedBlockingQueue<LeaderboardTask<InsertionConnection>> getUpdateTaskQueue() {
        return updateTaskQueue;
    }

    public static LinkedBlockingQueue<LeaderboardTask<RetrievalConnection>> getRetrievalTaskQueue() {
        return retrievalTaskQueue;
    }

    public static boolean isEnabled() {
        return enabled.get();
    }

    public static void init() {
        int i;
        enabled.set((Boolean)AoAConfigs.SERVER.skillsLeaderboardEnabled.get());
        if (!SkillsLeaderboard.isEnabled()) {
            return;
        }
        try {
            dataPath = FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get().resolve("aoa3"), (String)"aoa3").toAbsolutePath().toString();
        }
        catch (Exception ex) {
            Logging.logMessage(Level.ERROR, "Unable to create or access directory for database storage. Disabling leaderboard.", ex);
            SkillsLeaderboard.shutdown();
            return;
        }
        updateTaskQueue = new LinkedBlockingQueue();
        try {
            DriverManager.registerDriver((Driver)new JDBCDriver());
        }
        catch (SQLException ex) {
            Logging.logMessage(Level.ERROR, "Unable to attach Skills Leaderboard database driver, disabling leaderboard.", ex);
            SkillsLeaderboard.shutdown();
            return;
        }
        Logging.logMessage(Level.INFO, "Starting threads and opening connections for skills database..");
        int maxThreads = (Integer)AoAConfigs.SERVER.maxLeaderboardThreads.get();
        int updateThreadCount = maxThreads / 2;
        int retrievalThreadCount = maxThreads - updateThreadCount;
        Properties connectionProperties = new Properties();
        updateThreads = new InsertionConnection[updateThreadCount];
        retrievalThreads = new RetrievalConnection[retrievalThreadCount];
        connectionProperties.put("user", AoAConfigs.SERVER.databaseUsername.get());
        connectionProperties.put("password", AoAConfigs.SERVER.databasePassword.get());
        connectionProperties.put("shutdown", (Object)true);
        connectionProperties.put("hsqldb.log_size", (Object)5);
        for (i = 0; i < updateThreadCount; ++i) {
            SkillsLeaderboard.updateThreads[i] = new InsertionConnection(updateTaskQueue, connectionProperties);
            updateThreads[i].start();
        }
        for (i = 0; i < retrievalThreadCount; ++i) {
            SkillsLeaderboard.retrievalThreads[i] = new RetrievalConnection(retrievalTaskQueue, connectionProperties);
            retrievalThreads[i].start();
        }
        new InitializeLeaderboardTask().queue();
    }

    public static void shutdown() {
        enabled.set(false);
        if (updateThreads != null) {
            for (LeaderboardConnection leaderboardConnection : updateThreads) {
                try {
                    if (!leaderboardConnection.isAlive()) continue;
                    leaderboardConnection.join();
                }
                catch (InterruptedException ex) {
                    Logging.logMessage(Level.ERROR, "Tried to stop already interrupted consumer thread, this is awkward..", ex);
                }
            }
        }
        if (retrievalThreads != null) {
            for (LeaderboardConnection leaderboardConnection : retrievalThreads) {
                try {
                    if (!leaderboardConnection.isAlive()) continue;
                    leaderboardConnection.join();
                }
                catch (InterruptedException ex) {
                    Logging.logMessage(Level.ERROR, "Tried to stop already interrupted consumer thread, this is awkward..", ex);
                }
            }
        }
    }

    public static void queueUpdateTask(LeaderboardTask<InsertionConnection> task) {
        SkillsLeaderboard.getUpdateTaskQueue().add(task);
    }

    public static void queueRetrievalTask(LeaderboardTask<RetrievalConnection> task) {
        SkillsLeaderboard.getRetrievalTaskQueue().add(task);
    }

    static {
        enabled = new AtomicBoolean(true);
    }
}

