/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration;

import net.minecraftforge.fml.loading.FMLLoader;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.integration.patchouli.PatchouliIntegration;

public class IntegrationManager {
    static boolean jeiActive = false;
    static boolean reiActive = false;
    static boolean jerActive = false;
    static boolean immersiveEngineeringActive = false;
    static boolean patchouliActive = false;
    static boolean tinkersConstructActive = false;

    public static boolean isJEIActive() {
        return jeiActive && (Boolean)AoAConfigs.INTEGRATIONS.jeiIntegrationEnabled.get() != false;
    }

    public static boolean isREIActive() {
        return reiActive && (Boolean)AoAConfigs.INTEGRATIONS.reiIntegrationEnabled.get() != false;
    }

    public static boolean isJERActive() {
        return jerActive && (Boolean)AoAConfigs.INTEGRATIONS.jerIntegrationEnabled.get() != false;
    }

    public static boolean isImmersiveEngineeringActive() {
        return immersiveEngineeringActive && (Boolean)AoAConfigs.INTEGRATIONS.immersiveEngineeringEnabled.get() != false;
    }

    public static boolean isPatchouliActive() {
        return patchouliActive && (Boolean)AoAConfigs.INTEGRATIONS.patchouliEnabled.get() != false;
    }

    public static boolean isTinkersConstructActive() {
        return tinkersConstructActive && (Boolean)AoAConfigs.INTEGRATIONS.tinkersConstructEnabled.get() != false;
    }

    public static void init() {
        Logging.logStatusMessage("Checking for third-party integrations");
        if (IntegrationManager.isModPresent("jei")) {
            IntegrationManager.jeiPreInit();
        }
        if (IntegrationManager.isModPresent("rei")) {
            IntegrationManager.jeiPreInit();
        }
        if (IntegrationManager.isModPresent("jeresources")) {
            IntegrationManager.jerPreInit();
        }
        if (IntegrationManager.isModPresent("immersiveengineering")) {
            IntegrationManager.immersiveEngineeringPreInit();
        }
        if (IntegrationManager.isModPresent("patchouli")) {
            IntegrationManager.patchouliPreInit();
        }
    }

    public static void lateInit() {
    }

    private static void jeiPreInit() {
        Logging.logStatusMessage("Found JEI, integrating");
        jeiActive = true;
    }

    private static void reiPreInit() {
        Logging.logStatusMessage("Found REI, integrating");
        reiActive = true;
    }

    private static void jerPreInit() {
        Logging.logStatusMessage("Found JustEnoughResources, integrating");
        jerActive = true;
    }

    private static void immersiveEngineeringPreInit() {
        Logging.logStatusMessage("Found Immersive Engineering, integrating");
        immersiveEngineeringActive = true;
    }

    private static void patchouliPreInit() {
        Logging.logStatusMessage("Found Patchouli, Integrating");
        patchouliActive = true;
        PatchouliIntegration.preInit();
    }

    private static void tinkersConstructPreInit() {
        Logging.logStatusMessage("Found Tinkers Construct, Integrating");
        tinkersConstructActive = true;
    }

    public static boolean isModPresent(String modId) {
        return FMLLoader.getLoadingModList().getModFileById(modId) != null;
    }
}

