/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.block.functional.utility.TeaSink;
import net.tslat.aoa3.content.entity.base.AoATrader;
import net.tslat.aoa3.content.item.tablet.TabletItem;
import net.tslat.aoa3.data.server.AoASkillReqReloadListener;
import net.tslat.aoa3.player.PlayerDataManager;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.TagUtil;
import net.tslat.aoa3.util.WorldUtil;

public final class RestrictionEventHandler {
    public static void preInit() {
        RestrictionEventHandler.cancelEventIf(EntityTeleportEvent.EnderPearl.class, ev -> ev.getTargetY() >= (double)ev.getEntity().f_19853_.m_6042_().f_63865_(), new Predicate[0]);
        RestrictionEventHandler.cancelEventIf(LivingConversionEvent.Pre.class, ev -> ev.getEntity() instanceof AoATrader, new Predicate[0]);
        RestrictionEventHandler.cancelEventIf(PlayerEvent.BreakSpeed.class, ev -> WorldUtil.isWorld(ev.getEntity().f_19853_, AoADimensions.NOWHERE.key), new Predicate[0]);
        RestrictionEventHandler.cancelEventIf(BlockEvent.FluidPlaceBlockEvent.class, ev -> WorldUtil.isWorld((Level)ev.getLevel(), AoADimensions.NOWHERE.key), new Predicate[0]);
        RestrictionEventHandler.cancelEventIf(EntityMobGriefingEvent.class, ev -> ev.getEntity() != null && WorldUtil.isWorld(ev.getEntity().f_19853_, AoADimensions.NOWHERE.key), new Predicate[0]);
        RestrictionEventHandler.cancelEventIf(LivingDropsEvent.class, ev -> WorldUtil.isWorld(ev.getEntity().f_19853_, AoADimensions.NOWHERE.key), new Predicate[0]);
        RestrictionEventHandler.cancelEventIf(FillBucketEvent.class, ev -> WorldUtil.isWorld(ev.getLevel(), AoADimensions.NOWHERE.key) && EntityUtil.Predicates.SURVIVAL_PLAYER.test((Entity)ev.getEntity()), new Predicate[0]);
        RestrictionEventHandler.cancelEventIf(BlockEvent.BreakEvent.class, ev -> EntityUtil.Predicates.SURVIVAL_PLAYER.test((Entity)ev.getPlayer()) && (WorldUtil.isWorld((Level)ev.getLevel(), AoADimensions.NOWHERE.key) || !AoASkillReqReloadListener.canBreakBlock(PlayerUtil.getAdventPlayer(ev.getPlayer()), ev.getState().m_60734_(), true)), new Predicate[0]);
        RestrictionEventHandler.cancelEventIf(BlockEvent.EntityPlaceEvent.class, ev -> EntityUtil.Predicates.SURVIVAL_PLAYER.test(ev.getEntity()) && (WorldUtil.isWorld((Level)ev.getLevel(), AoADimensions.NOWHERE.key) || !AoASkillReqReloadListener.canPlaceBlock(PlayerUtil.getAdventPlayer((Player)ev.getEntity()), ev.getState().m_60734_(), true)), new Predicate[0]);
        RestrictionEventHandler.handleEventIf(ExplosionEvent.Detonate.class, ev -> ev.getAffectedBlocks().clear(), ev -> WorldUtil.isWorld(ev.getLevel(), AoADimensions.NOWHERE.key), new Predicate[0]);
        RestrictionEventHandler.handleEventIf(EntityTeleportEvent.class, ev -> {
            RestrictionEventHandler.cancelEvent(ev);
            PlayerUtil.notifyPlayer((Player)ev.getEntity(), (Component)Component.m_237115_((String)"message.feedback.nowhere.teleport"));
        }, ev -> WorldUtil.isWorld(ev.getEntity().f_19853_, AoADimensions.NOWHERE.key) && EntityUtil.Predicates.SURVIVAL_PLAYER.test(ev.getEntity()) && !(ev instanceof EntityTeleportEvent.TeleportCommand) && !(ev instanceof EntityTeleportEvent.SpreadPlayersCommand), new Predicate[0]);
        RestrictionEventHandler.handleEventIf(PlayerInteractEvent.RightClickBlock.class, RestrictionEventHandler::handleRightClickBlock, ev -> !WorldUtil.isWorld(ev.getEntity().f_19853_, AoADimensions.NOWHERE.key) && EntityUtil.Predicates.SURVIVAL_PLAYER.test((Entity)ev.getEntity()), new Predicate[0]);
        RestrictionEventHandler.handleEventIf(PlayerInteractEvent.RightClickBlock.class, RestrictionEventHandler::handleNowhereRightClickBlock, ev -> WorldUtil.isWorld(ev.getEntity().f_19853_, AoADimensions.NOWHERE.key) && EntityUtil.Predicates.SURVIVAL_PLAYER.test((Entity)ev.getEntity()), new Predicate[0]);
    }

    private static void handleNowhereRightClickBlock(PlayerInteractEvent.RightClickBlock ev) {
        BlockState blockState = ev.getLevel().m_8055_(ev.getPos());
        Block block = blockState.m_60734_();
        Item heldItem = ev.getEntity().m_21120_(ev.getHand()).m_41720_();
        if (block == Blocks.f_50131_) {
            if (heldItem == Items.f_41852_ || heldItem instanceof RecordItem) {
                ev.setUseItem(Event.Result.ALLOW);
                ev.setUseBlock(Event.Result.ALLOW);
                ev.getEntity().m_150110_().f_35938_ = true;
            }
        } else if (TagUtil.isTaggedAs(block, AoATags.Blocks.NOWHERE_SAFE_GUI_BLOCK)) {
            ev.setUseItem(Event.Result.DENY);
        } else if (block == Blocks.f_152476_) {
            ev.setUseItem(Event.Result.DENY);
            AoAScheduler.scheduleSyncronisedTask(() -> ev.getLevel().m_7731_(ev.getPos(), (BlockState)blockState.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), 2), 1);
        } else if (block == AoABlocks.TEA_SINK.get()) {
            ev.setUseItem(Event.Result.DENY);
            AoAScheduler.scheduleSyncronisedTask(() -> ev.getLevel().m_7731_(ev.getPos(), (BlockState)blockState.m_61124_((Property)TeaSink.FILLED, (Comparable)Boolean.valueOf(true)), 2), 1);
        } else if (heldItem instanceof TabletItem || heldItem == AoAItems.LOTTO_TOTEM.get()) {
            ev.setUseItem(Event.Result.ALLOW);
            ev.setUseBlock(Event.Result.DENY);
            ev.getEntity().m_150110_().f_35938_ = true;
        } else {
            ev.setCanceled(true);
        }
    }

    private static void handleRightClickBlock(PlayerInteractEvent.RightClickBlock ev) {
        Item item;
        Level world = ev.getLevel();
        PlayerDataManager plData = PlayerUtil.getAdventPlayer(ev.getEntity());
        if (!AoASkillReqReloadListener.canInteractWith(plData, world.m_8055_(ev.getPos()).m_60734_(), true)) {
            ev.setUseBlock(Event.Result.DENY);
        }
        if ((item = ev.getItemStack().m_41720_()) instanceof BlockItem && !AoASkillReqReloadListener.canPlaceBlock(plData, ((BlockItem)item).m_40614_(), true)) {
            ev.setUseItem(Event.Result.DENY);
        }
    }

    private static <T extends Event> void handleEvent(Class<T> eventClass, Consumer<T> handler) {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, false, eventClass, handler);
    }

    private static <T extends Event> void handleEventIf(Class<T> eventClass, Consumer<T> handler, Predicate<T> basePredicate, Predicate<T> ... predicates) {
        RestrictionEventHandler.handleEvent(eventClass, RestrictionEventHandler.wrapEventConditionally(RestrictionEventHandler.or(basePredicate, predicates), handler));
    }

    private static <T extends Event> void cancelEventIf(Class<T> eventClass, Predicate<T> basePredicate, Predicate<T> ... predicates) {
        RestrictionEventHandler.handleEvent(eventClass, RestrictionEventHandler.wrapEventConditionally(RestrictionEventHandler.or(basePredicate, predicates), RestrictionEventHandler::cancelEvent));
    }

    private static <T extends Event> void cancelEvent(T ev) {
        if (ev.isCancelable()) {
            ev.setCanceled(true);
        }
        if (ev.hasResult()) {
            ev.setResult(Event.Result.DENY);
        }
    }

    private static <T extends Event> Predicate<T> and(Predicate<T> basePredicate, Predicate<T> ... predicates) {
        for (Predicate<T> predicate : predicates) {
            basePredicate = basePredicate.and(predicate);
        }
        return basePredicate;
    }

    private static <T extends Event> Predicate<T> or(Predicate<T> basePredicate, Predicate<T> ... predicates) {
        for (Predicate<T> predicate : predicates) {
            basePredicate = basePredicate.or(predicate);
        }
        return basePredicate;
    }

    private static <T extends Event> Consumer<T> wrapEventConditionally(Predicate<T> predicate, Consumer<T> handler) {
        return t -> {
            if (predicate.test(t)) {
                handler.accept(t);
            }
        };
    }
}

