/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event;

import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.item.AoATools;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.block.functional.misc.CheckpointBlock;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.content.item.misc.ReservedItem;
import net.tslat.aoa3.content.item.misc.ReturnCrystal;
import net.tslat.aoa3.content.item.misc.summoning.BossSpawningItem;
import net.tslat.aoa3.content.item.tool.misc.ExpFlask;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.data.server.AoASkillReqReloadListener;
import net.tslat.aoa3.event.dimension.LelyetiaEvents;
import net.tslat.aoa3.event.dimension.LunalusEvents;
import net.tslat.aoa3.event.dimension.NowhereEvents;
import net.tslat.aoa3.event.dimension.VoxPondsEvents;
import net.tslat.aoa3.library.object.PositionAndRotation;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.AoAHaloUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;

public class PlayerEvents {
    public static void preInit() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, false, TickEvent.PlayerTickEvent.class, PlayerEvents::onPlayerTick);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingEvent.LivingJumpEvent.class, PlayerEvents::onPlayerJump);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingAttackEvent.class, PlayerEvents::onPlayerHit);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingHurtEvent.class, PlayerEvents::onPlayerHurt);
        forgeBus.addListener(EventPriority.LOWEST, false, LivingDamageEvent.class, PlayerEvents::onPlayerDamaged);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingFallEvent.class, PlayerEvents::onPlayerFall);
        forgeBus.addListener(EventPriority.LOWEST, false, LivingDeathEvent.class, PlayerEvents::onEntityDeath);
        forgeBus.addListener(EventPriority.NORMAL, false, BlockEvent.BreakEvent.class, PlayerEvents::onBlockBreak);
        forgeBus.addListener(EventPriority.NORMAL, false, BlockEvent.EntityPlaceEvent.class, PlayerEvents::onBlockPlace);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerEvent.PlayerLoggedInEvent.class, PlayerEvents::onPlayerLogin);
        forgeBus.addListener(EventPriority.NORMAL, false, ItemTossEvent.class, PlayerEvents::onItemToss);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerXpEvent.PickupXp.class, PlayerEvents::onPlayerPickupXp);
        forgeBus.addListener(EventPriority.NORMAL, false, ItemFishedEvent.class, PlayerEvents::onPlayerFishing);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerEvent.PlayerChangedDimensionEvent.class, PlayerEvents::onDimensionChange);
    }

    private static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END) {
            if (WorldUtil.isWorld(ev.player.f_19853_, AoADimensions.LELYETIA.key)) {
                LelyetiaEvents.doPlayerTick(ev.player);
            } else if (WorldUtil.isWorld(ev.player.f_19853_, AoADimensions.VOX_PONDS.key)) {
                VoxPondsEvents.doPlayerTick(ev.player);
            } else if (WorldUtil.isWorld(ev.player.f_19853_, AoADimensions.LUNALUS.key)) {
                LunalusEvents.doPlayerTick(ev.player);
            }
        } else if (WorldUtil.isWorld(ev.player.f_19853_, AoADimensions.NOWHERE.key)) {
            NowhereEvents.doPlayerTick(ev);
        }
    }

    private static void onPlayerJump(LivingEvent.LivingJumpEvent ev) {
        if (WorldUtil.isWorld(ev.getEntity().f_19853_, AoADimensions.LUNALUS.key) && ev.getEntity() instanceof Player) {
            LunalusEvents.doPlayerJump((Player)ev.getEntity());
        }
    }

    private static void onPlayerHit(LivingAttackEvent ev) {
        if (ev.getEntity() instanceof ServerPlayer && ev.getEntity().m_21223_() - ev.getAmount() <= 0.0f && ev.getEntity().f_19853_.m_6106_().m_5466_()) {
            ReservedItem.handlePlayerDeath((Player)((ServerPlayer)ev.getEntity()));
        }
    }

    private static void onPlayerHurt(LivingHurtEvent ev) {
        ServerPlayer pl;
        LivingEntity livingEntity;
        ItemStack weapon;
        Entity attacker = ev.getSource().m_7639_();
        if (DamageUtil.isMeleeDamage(ev.getSource()) && attacker instanceof LivingEntity && (weapon = ((LivingEntity)attacker).m_21120_(InteractionHand.MAIN_HAND)).m_41720_() instanceof BaseSword) {
            ev.setAmount((float)((BaseSword)weapon.m_41720_()).getDamageForAttack(ev.getEntity(), (LivingEntity)attacker, weapon, ev.getAmount()));
        }
        if ((livingEntity = ev.getEntity()) instanceof ServerPlayer && (pl = (ServerPlayer)livingEntity).m_21223_() > 0.0f && ev.getSource().m_19372_() && ev.getSource().m_7640_() instanceof Creeper && (!pl.f_19853_.m_45976_(PrimedTnt.class, ev.getSource().m_7640_().m_20191_().m_82400_(3.0)).isEmpty() || !pl.f_19853_.m_45976_(PrimedTnt.class, pl.m_20191_().m_82400_(3.0)).isEmpty()) && ItemUtil.findInventoryItem((Player)pl, new ItemStack((ItemLike)AoAItems.BLANK_REALMSTONE.get()), true, 1)) {
            ItemUtil.givePlayerItemOrDrop((Player)pl, new ItemStack((ItemLike)AoAItems.CREEPONIA_REALMSTONE.get()));
        }
    }

    private static void onPlayerDamaged(LivingDamageEvent ev) {
        ServerPlayer pl;
        if (ev.getSource() == DamageSource.f_19317_) {
            return;
        }
        LivingEntity livingEntity = ev.getEntity();
        if (livingEntity instanceof ServerPlayer && (pl = (ServerPlayer)livingEntity).m_21223_() <= ev.getAmount()) {
            ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
            PositionAndRotation checkpoint = plData.getCheckpoint();
            if (checkpoint != null) {
                if (CheckpointBlock.isValidCheckpoint(pl.f_19853_, checkpoint)) {
                    PlayerUtil.resetToDefaultStatus(pl);
                    pl.m_213846_((Component)LocaleUtil.getLocaleMessage("message.feedback.checkpoint", ChatFormatting.GREEN, new Component[0]));
                    checkpoint.applyToEntity((Entity)pl);
                    ev.setCanceled(true);
                    return;
                }
                plData.clearCheckpoint();
                pl.m_213846_((Component)LocaleUtil.getLocaleMessage("message.feedback.checkpoint.invalid", ChatFormatting.RED, new Component[0]));
            }
            if (ev.getEntity().f_19853_.m_46472_() == AoADimensions.NOWHERE.key) {
                NowhereEvents.doDeathPrevention(ev, plData);
            }
        }
    }

    private static void onPlayerFall(LivingFallEvent ev) {
        LivingEntity livingEntity = ev.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (ev.getDistance() > 25.0f && ev.getDamageMultiplier() > 0.0f && ItemUtil.findInventoryItem((Player)player, new ItemStack((ItemLike)AoAItems.BLANK_REALMSTONE.get()), true, 1)) {
                ItemUtil.givePlayerItemOrDrop((Player)player, new ItemStack((ItemLike)AoAItems.LELYETIA_REALMSTONE.get()));
            }
            if (WorldUtil.isWorld(player.f_19853_, AoADimensions.LUNALUS.key)) {
                LunalusEvents.doPlayerLanding((Player)player, ev);
            }
        }
    }

    private static void onEntityDeath(LivingDeathEvent ev) {
        if (!ev.getEntity().f_19853_.f_46443_) {
            if (ev.getEntity() instanceof ServerPlayer) {
                ReservedItem.handlePlayerDeath((Player)((ServerPlayer)ev.getEntity()));
            } else if (ev.getSource().m_7639_() instanceof ServerPlayer && WorldUtil.isWorld(ev.getEntity().f_19853_, AoADimensions.DEEPLANDS.key) && ev.getEntity() instanceof FlyingMob) {
                ev.getEntity().m_5552_(new ItemStack((ItemLike)AoAItems.MUSIC_DISC_CAVERNS.get()), 0.5f);
            }
        }
    }

    private static void onBlockBreak(BlockEvent.BreakEvent ev) {
        Player pl = ev.getPlayer();
        if (pl instanceof ServerPlayer) {
            BlockPos pos = ev.getPos();
            if (!pl.m_7500_() && ev.getState().m_204336_(Tags.Blocks.ORES) && pos.m_123342_() <= pl.f_19853_.m_141937_() + 5 && ItemUtil.findInventoryItem(pl, new ItemStack((ItemLike)AoAItems.BLANK_REALMSTONE.get()), true, 1)) {
                ItemUtil.givePlayerItemOrDrop(pl, new ItemStack((ItemLike)AoAItems.DEEPLANDS_REALMSTONE.get()));
            }
        }
    }

    private static void onBlockPlace(BlockEvent.EntityPlaceEvent ev) {
        Entity entity = ev.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (PlayerUtil.isWearingFullSet(player, AdventArmour.Type.HYDRANGIC) && ev.getPlacedBlock().m_60734_() instanceof BonemealableBlock && BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.f_42499_), (Level)ev.getEntity().f_19853_, (BlockPos)ev.getPos(), (Player)player)) {
            ev.getLevel().m_46796_(2005, ev.getPos(), 0);
            player.m_6472_(DamageSource.f_19318_, 16.0f);
        }
    }

    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent ev) {
        Player player = ev.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            UUID uuid = player2.m_36316_().getId();
            String msg = null;
            if (uuid.compareTo(UUID.fromString("2459b511-ca45-43d8-808d-f0eb30a63be4")) == 0) {
                msg = ChatFormatting.DARK_RED + "It begins...Is this the end?";
                ((ServerLevel)player2.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123755_, player2.m_20185_(), player2.m_20186_() + 0.2, player2.m_20189_(), 16, (double)RandomUtil.randomValueUpTo(0.1f) - 0.05, (double)RandomUtil.randomValueUpTo(0.1f) - 0.05, (double)RandomUtil.randomValueUpTo(0.1f) - 0.05, 1.0);
            } else if (AoAHaloUtil.isCrazyDonator(uuid)) {
                msg = ChatFormatting.LIGHT_PURPLE + "They approach. Tremble before them.";
            }
            if (msg != null) {
                player2.m_20194_().m_6846_().m_240416_((Component)Component.m_237113_((String)msg), false);
            }
            AoAHaloUtil.syncWithNewClient(player2);
            ServerPlayerDataManager.syncNewPlayer(player2);
            AoASkillReqReloadListener.syncNewPlayer(player2);
            PlayerAdvancements plAdvancements = player2.m_8960_();
            Advancement rootAdv = AdvancementUtil.getAdvancement(new ResourceLocation("aoa3", "overworld/root"));
            if (rootAdv == null) {
                Logging.logMessage(org.apache.logging.log4j.Level.WARN, "Unable to find inbuilt advancements, another mod is breaking things.");
            } else if (!plAdvancements.m_135996_(rootAdv).m_8193_()) {
                plAdvancements.m_135988_(AdvancementUtil.getAdvancement(new ResourceLocation("aoa3", "overworld/by_the_books")), "legitimate");
                plAdvancements.m_135988_(rootAdv, "playerjoin");
            }
        }
    }

    private static void onItemToss(ItemTossEvent ev) {
        if (ev.getPlayer() instanceof ServerPlayer) {
            ItemEntity entityItem = ev.getEntity();
            Item item = entityItem.m_32055_().m_41720_();
            if (item == AoAItems.BLANK_REALMSTONE.get()) {
                if (ev.getEntity().m_20077_()) {
                    ItemUtil.givePlayerItemOrDrop(ev.getPlayer(), new ItemStack((ItemLike)AoAItems.NETHER_REALMSTONE.get()));
                    ev.getEntity().m_146870_();
                }
            } else if (item instanceof ReservedItem) {
                ReservedItem.handlePlayerToss(ev);
            } else if (item instanceof BossSpawningItem) {
                BossSpawningItem bossItem = (BossSpawningItem)item;
                Level world = ev.getEntity().m_20193_();
                if (world.m_46791_() == Difficulty.PEACEFUL) {
                    ev.getEntity().m_213846_((Component)Component.m_237115_((String)"message.feedback.spawnBoss.difficultyFail"));
                    return;
                }
                ev.setCanceled(true);
                world.m_7967_((Entity)BossSpawningItem.newBossEntityItemFromExisting(entityItem, ev.getPlayer()));
                if (bossItem.getThrowingSound() != null) {
                    world.m_6263_(null, entityItem.m_20185_(), entityItem.m_20185_(), entityItem.m_20189_(), bossItem.getThrowingSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else if (item instanceof ReturnCrystal) {
                ev.setCanceled(true);
            }
        }
    }

    private static void onPlayerPickupXp(PlayerXpEvent.PickupXp ev) {
        ItemStack stack;
        if (!ev.getEntity().f_19853_.f_46443_ && ev.getOrb().f_20770_ > 0 && (stack = ItemUtil.getStackFromInventory(ev.getEntity(), (Item)AoATools.EXP_FLASK.get())) != null) {
            ExpFlask.addExp(stack, ev.getOrb().f_20770_);
            ev.setCanceled(true);
            ev.getOrb().f_20770_ = 0;
            ev.getOrb().m_146870_();
        }
    }

    private static void onPlayerFishing(ItemFishedEvent ev) {
        if (WorldUtil.isWorld(ev.getEntity().f_19853_, AoADimensions.LBOREAN.key) && RandomUtil.oneInNChance(10)) {
            FishingHook hook = ev.getHookEntity();
            Player fisher = ev.getEntity();
            ItemEntity drop = new ItemEntity(fisher.f_19853_, hook.m_20185_(), hook.m_20186_(), hook.m_20189_(), new ItemStack((ItemLike)AoAItems.CALL_OF_THE_DRAKE.get()));
            double velocityX = fisher.m_20185_() - hook.m_20185_();
            double velocityY = fisher.m_20186_() - hook.m_20186_();
            double velocityZ = fisher.m_20189_() - hook.m_20189_();
            double velocity = Math.sqrt(velocityX * velocityX + velocityY * velocityY + velocityZ * velocityZ);
            drop.m_20334_(velocityX * 0.1, velocityY * 0.1 + Math.sqrt(velocity) * 0.08, velocityZ * 0.1);
            fisher.f_19853_.m_7967_((Entity)drop);
        }
    }

    private static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent ev) {
        Player player;
        if (ev.getFrom() == AoADimensions.NOWHERE.key) {
            NowhereEvents.doDimensionChange(ev);
        }
        if ((player = ev.getEntity()) instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)player;
            PlayerUtil.getAdventPlayer(pl).clearCheckpoint();
        }
    }
}

