/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.data.server;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.EntityRetrievalUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.ObjectUtil;
import net.tslat.aoa3.util.RandomUtil;

public class AoANowhereBossArenaListener
extends SimpleJsonResourceReloadListener {
    private static final List<NowhereBossArena> REGISTERED_ARENAS = new ObjectArrayList();
    private static final String folder = "worldgen/nowhere_boss_arenas";

    public AoANowhereBossArenaListener() {
        super(new GsonBuilder().setPrettyPrinting().create(), folder);
    }

    protected void apply(Map<ResourceLocation, JsonElement> entryMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        REGISTERED_ARENAS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : entryMap.entrySet()) {
            Either result = NowhereBossArena.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).get();
            if (result.right().isPresent()) {
                Logging.logMessage(org.apache.logging.log4j.Level.ERROR, "Unable to deserialize boss arena, disabling. (" + entry.getKey() + ") " + ((DataResult.PartialResult)result.right().get()).message());
                continue;
            }
            NowhereBossArena nowhereBossArena = (NowhereBossArena)result.left().get();
            if (nowhereBossArena.playerSpawnPoints.isEmpty()) {
                Logging.logMessage(org.apache.logging.log4j.Level.ERROR, "No player spawn points provided for boss arena, disabling arena. " + entry.getKey());
                continue;
            }
            if (nowhereBossArena.bossSpawnPoints.isEmpty()) {
                Logging.logMessage(org.apache.logging.log4j.Level.ERROR, "No boss spawn points provided for boss arena, disabling arena. " + entry.getKey());
                continue;
            }
            REGISTERED_ARENAS.add(nowhereBossArena);
        }
    }

    @Nullable
    public static NowhereBossArena getFreeArena(ServerLevel level) {
        if (RandomUtil.oneInNChance(5)) {
            ObjectUtil.fastShuffleList(REGISTERED_ARENAS);
        }
        for (NowhereBossArena arena : REGISTERED_ARENAS) {
            if (!arena.checkAndClear(level)) continue;
            return arena;
        }
        return null;
    }

    public static class NowhereBossArena {
        public static final Codec<NowhereBossArena> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.f_135803_.fieldOf("structure_id").forGetter(arena -> arena.structureId), (App)BlockPos.f_121852_.fieldOf("arena_pos").forGetter(arena -> arena.structurePos), (App)Vec3.f_231074_.listOf().fieldOf("player_spawns").forGetter(arena -> arena.playerSpawnPoints), (App)Vec3.f_231074_.listOf().fieldOf("boss_spawns").forGetter(arena -> arena.bossSpawnPoints)).apply((Applicative)builder, NowhereBossArena::new));
        public final ResourceLocation structureId;
        private final BlockPos structurePos;
        private final List<Vec3> playerSpawnPoints;
        private final List<Vec3> bossSpawnPoints;
        private Structure structure = null;
        private StructureStart structureStart = null;
        private AABB structureBounds = null;

        public NowhereBossArena(ResourceLocation structureId, BlockPos structurePos, List<Vec3> playerSpawnPoints, List<Vec3> bossSpawnPoints) {
            this.structureId = structureId;
            this.structurePos = structurePos;
            this.playerSpawnPoints = playerSpawnPoints;
            this.bossSpawnPoints = bossSpawnPoints;
        }

        public boolean checkAndClear(ServerLevel level) {
            if (!this.getPlayersInside(level).isEmpty()) {
                return false;
            }
            for (Entity entity : this.getEntitiesInside(level)) {
                entity.m_146870_();
            }
            return true;
        }

        public void placePlayersAndBoss(ServerLevel level, List<ServerPlayer> players, Predicate<ServerPlayer> playerStillValid, BiFunction<ServerLevel, Vec3, Entity> bossFunction) {
            if (players.isEmpty()) {
                return;
            }
            StructureStart structureStart = this.getStructureStart(level);
            if (structureStart == null) {
                return;
            }
            AoAScheduler.scheduleSyncronisedTask(() -> {
                boolean spawnBoss = false;
                for (ServerPlayer player : players) {
                    if (!playerStillValid.test(player)) continue;
                    Vec3 pos = RandomUtil.getRandomSelection(this.playerSpawnPoints);
                    spawnBoss = true;
                    player.f_8906_.m_9774_(pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0f, 0.0f);
                    ItemUtil.givePlayerItemOrDrop((Player)player, new ItemStack((ItemLike)AoAItems.RETURN_CRYSTAL.get()));
                    player.m_213846_((Component)LocaleUtil.getLocaleMessage("message.feedback.nowhere.boss.bossWarning"));
                }
                if (spawnBoss) {
                    AoAScheduler.scheduleSyncronisedTask(() -> bossFunction.apply(level, RandomUtil.getRandomSelection(this.bossSpawnPoints)), 100);
                }
            }, 100);
            for (ServerPlayer player : players) {
                player.m_213846_((Component)LocaleUtil.getLocaleMessage("message.feedback.nowhere.boss.teleportWarning"));
            }
        }

        @Nullable
        private Structure getStructure(ServerLevel level) {
            if (this.structure != null) {
                return this.structure;
            }
            this.structure = (Structure)((Registry)level.m_5962_().m_6632_(Registry.f_235725_).get()).m_7745_(this.structureId);
            return this.structure;
        }

        @Nullable
        private StructureStart getStructureStart(ServerLevel level) {
            if (this.structureStart != null) {
                return this.structureStart;
            }
            Structure structure = this.getStructure(level);
            if (structure == null) {
                return null;
            }
            this.structureStart = level.m_215010_().m_220494_(this.structurePos, structure);
            return this.structureStart;
        }

        @Nullable
        public AABB getStructureBounds(ServerLevel level) {
            if (this.structureBounds != null) {
                return this.structureBounds;
            }
            StructureStart structureStart = this.getStructureStart(level);
            if (structureStart == null) {
                return null;
            }
            this.structureBounds = AABB.m_82321_((BoundingBox)structureStart.m_73601_());
            return this.structureBounds;
        }

        public List<Player> getPlayersInside(ServerLevel level) {
            AABB bounds = this.getStructureBounds(level);
            if (bounds == null) {
                return List.of();
            }
            return EntityRetrievalUtil.getPlayers((Level)level, bounds);
        }

        public List<Entity> getEntitiesInside(ServerLevel level) {
            AABB bounds = this.getStructureBounds(level);
            if (bounds == null) {
                return List.of();
            }
            return EntityRetrievalUtil.getEntities((Level)level, bounds, entity -> true);
        }
    }
}

