/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoATreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public class ShadowTreeFeature
extends AoATreeFeature {
    public ShadowTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, RandomSource rand, BlockPos pos, boolean isWorldGen) {
        int i;
        int trunkHeight = 8 + rand.m_188503_(6);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 1, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.SHADOW_LOG.get()).m_49966_();
        BlockState barkLog = ((Block)AoABlocks.SHADOW_WOOD.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.SHADOW_LEAVES.get()).m_49966_();
        int branchWidth = 1 + rand.m_188503_(4);
        boolean additionalLeaves = rand.m_188499_();
        for (i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        }
        this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), barkLog);
        for (i = 1; i <= branchWidth; ++i) {
            this.placeBlock(reader, movablePos.m_122013_(i), barkLog);
            this.placeBlock(reader, movablePos.m_122020_(i), barkLog);
            this.placeBlock(reader, movablePos.m_122030_(i), barkLog);
            this.placeBlock(reader, movablePos.m_122025_(i), barkLog);
        }
        for (i = branchWidth + 1; i <= branchWidth + 3; ++i) {
            this.placeBlock(reader, movablePos.m_7918_(i, 0, 0), leaves);
            this.placeBlock(reader, movablePos.m_7918_(i, -2, 1), leaves);
            this.placeBlock(reader, movablePos.m_7918_(i, -2, -1), leaves);
            this.placeBlock(reader, movablePos.m_7918_(-i, 0, 0), leaves);
            this.placeBlock(reader, movablePos.m_7918_(-i, -2, 1), leaves);
            this.placeBlock(reader, movablePos.m_7918_(-i, -2, -1), leaves);
            this.placeBlock(reader, movablePos.m_7918_(0, 0, i), leaves);
            this.placeBlock(reader, movablePos.m_7918_(1, -2, i), leaves);
            this.placeBlock(reader, movablePos.m_7918_(-1, -2, i), leaves);
            this.placeBlock(reader, movablePos.m_7918_(0, 0, -i), leaves);
            this.placeBlock(reader, movablePos.m_7918_(1, -2, -i), leaves);
            this.placeBlock(reader, movablePos.m_7918_(-1, -2, -i), leaves);
            if (i == branchWidth + 3) {
                this.placeBlock(reader, movablePos.m_7918_(i, -1, 0), leaves);
                this.placeBlock(reader, movablePos.m_7918_(-i, -1, 0), leaves);
                this.placeBlock(reader, movablePos.m_7918_(0, -1, i), leaves);
                this.placeBlock(reader, movablePos.m_7918_(0, -1, -i), leaves);
                this.placeBlock(reader, movablePos.m_7918_(i, -3, 1), leaves);
                this.placeBlock(reader, movablePos.m_7918_(i, -3, -1), leaves);
                this.placeBlock(reader, movablePos.m_7918_(-i, -3, 1), leaves);
                this.placeBlock(reader, movablePos.m_7918_(-i, -3, -1), leaves);
                this.placeBlock(reader, movablePos.m_7918_(1, -3, i), leaves);
                this.placeBlock(reader, movablePos.m_7918_(-1, -3, i), leaves);
                this.placeBlock(reader, movablePos.m_7918_(1, -3, -i), leaves);
                this.placeBlock(reader, movablePos.m_7918_(-1, -3, -i), leaves);
                this.placeBlock(reader, movablePos.m_7918_(i, -4, 1), leaves);
                this.placeBlock(reader, movablePos.m_7918_(i, -4, -1), leaves);
                this.placeBlock(reader, movablePos.m_7918_(-i, -4, 1), leaves);
                this.placeBlock(reader, movablePos.m_7918_(-i, -4, -1), leaves);
                this.placeBlock(reader, movablePos.m_7918_(1, -4, i), leaves);
                this.placeBlock(reader, movablePos.m_7918_(-1, -4, i), leaves);
                this.placeBlock(reader, movablePos.m_7918_(1, -4, -i), leaves);
                this.placeBlock(reader, movablePos.m_7918_(-1, -4, -i), leaves);
                continue;
            }
            this.placeBlock(reader, movablePos.m_7918_(i, -1, 0), barkLog);
            this.placeBlock(reader, movablePos.m_7918_(-i, -1, 0), barkLog);
            this.placeBlock(reader, movablePos.m_7918_(0, -1, i), barkLog);
            this.placeBlock(reader, movablePos.m_7918_(0, -1, -i), barkLog);
            if (i == branchWidth + 1) {
                this.placeBlock(reader, movablePos.m_7918_(i, -3, 1), leaves);
                this.placeBlock(reader, movablePos.m_7918_(i, -3, -1), leaves);
                this.placeBlock(reader, movablePos.m_7918_(-i, -3, 1), leaves);
                this.placeBlock(reader, movablePos.m_7918_(-i, -3, -1), leaves);
                this.placeBlock(reader, movablePos.m_7918_(1, -3, i), leaves);
                this.placeBlock(reader, movablePos.m_7918_(-1, -3, i), leaves);
                this.placeBlock(reader, movablePos.m_7918_(1, -3, -i), leaves);
                this.placeBlock(reader, movablePos.m_7918_(-1, -3, -i), leaves);
                this.placeBlock(reader, movablePos.m_7918_(i, -4, 1), leaves);
                this.placeBlock(reader, movablePos.m_7918_(i, -4, -1), leaves);
                this.placeBlock(reader, movablePos.m_7918_(-i, -4, 1), leaves);
                this.placeBlock(reader, movablePos.m_7918_(-i, -4, -1), leaves);
                this.placeBlock(reader, movablePos.m_7918_(1, -4, i), leaves);
                this.placeBlock(reader, movablePos.m_7918_(-1, -4, i), leaves);
                this.placeBlock(reader, movablePos.m_7918_(1, -4, -i), leaves);
                this.placeBlock(reader, movablePos.m_7918_(-1, -4, -i), leaves);
            }
            if (!additionalLeaves) continue;
            this.placeBlock(reader, movablePos.m_7918_(i, -1, 1), leaves);
            this.placeBlock(reader, movablePos.m_7918_(i, -1, -1), leaves);
            this.placeBlock(reader, movablePos.m_7918_(-i, -1, 1), leaves);
            this.placeBlock(reader, movablePos.m_7918_(-i, -1, -1), leaves);
            this.placeBlock(reader, movablePos.m_7918_(1, -1, i), leaves);
            this.placeBlock(reader, movablePos.m_7918_(-1, -1, i), leaves);
            this.placeBlock(reader, movablePos.m_7918_(1, -1, -i), leaves);
            this.placeBlock(reader, movablePos.m_7918_(-1, -1, -i), leaves);
        }
        return true;
    }
}

