/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.tslat.aoa3.advent.Logging;
import org.apache.logging.log4j.Level;

public class RollExtraTablesLootModifier
extends LootModifier {
    public static final Codec<RollExtraTablesLootModifier> CODEC = RecordCodecBuilder.create(builder -> RollExtraTablesLootModifier.codecStart((RecordCodecBuilder.Instance)builder).and((App)ResourceLocation.f_135803_.listOf().fieldOf("tables").forGetter(instance -> instance.additionalTables)).apply((Applicative)builder, RollExtraTablesLootModifier::new));
    private final List<ResourceLocation> additionalTables;

    public RollExtraTablesLootModifier(LootItemCondition[] conditions, List<ResourceLocation> additionalTables) {
        super(conditions);
        this.additionalTables = additionalTables;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (ResourceLocation tableLocation : this.additionalTables) {
            LootTable table = context.m_78940_(tableLocation);
            boolean compatible = true;
            for (LootContextParam param : table.m_79122_().m_81394_()) {
                if (context.m_78936_(param)) continue;
                compatible = false;
                Logging.logMessage(Level.WARN, "Incompatible loot table found for Roll Extra Tables Loot Modifier: " + tableLocation.toString() + ", missing: " + param.m_81284_().toString());
                break;
            }
            if (!compatible || table == LootTable.f_79105_) continue;
            table.m_79148_(context, arg_0 -> generatedLoot.add(arg_0));
        }
        return generatedLoot;
    }
}

