/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.entity.projectile.staff.NoxiousShotEntity;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.builder.EffectBuilder;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class NoxiousStaff
extends BaseStaff<Object> {
    public NoxiousStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_NOXIOUS_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.WIND_RUNE.get(), 2);
        runes.put((Item)AoAItems.POISON_RUNE.get(), 2);
        runes.put((Item)AoAItems.STORM_RUNE.get(), 2);
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, Object args) {
        world.m_7967_((Entity)new NoxiousShotEntity(caster, this, 60, 0.0f, 0.0f, 0.0f));
        world.m_7967_((Entity)new NoxiousShotEntity(caster, this, 60, 0.075f, 0.075f, 0.0f));
        world.m_7967_((Entity)new NoxiousShotEntity(caster, this, 60, -0.075f, 0.0f, 0.075f));
        world.m_7967_((Entity)new NoxiousShotEntity(caster, this, 60, 0.0f, -0.075f, -0.075f));
        world.m_7967_((Entity)new NoxiousShotEntity(caster, this, 60, -0.075f, 0.075f, -0.075f));
        world.m_7967_((Entity)new NoxiousShotEntity(caster, this, 60, -0.075f, -0.075f, 0.075f));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (DamageUtil.dealMagicDamage((Entity)shot, shooter, target, this.getDmg(), false)) {
            EntityUtil.applyPotions(target, new EffectBuilder(MobEffects.f_19614_, 100).level(3));
            return true;
        }
        return false;
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3 pos, LivingEntity shooter) {
        AreaEffectCloud cloud = new AreaEffectCloud(shot.f_19853_, shot.m_20185_(), shot.m_20186_(), shot.m_20189_());
        cloud.m_19712_(3.0f);
        cloud.m_19722_(Potions.f_43586_);
        cloud.m_19716_(new MobEffectInstance(MobEffects.f_19614_, 100, 2, true, true));
        cloud.m_19734_(3);
        cloud.m_19714_(ColourUtil.RGB(51, 102, 0));
        cloud.m_19718_(shooter);
        shot.f_19853_.m_7967_((Entity)cloud);
    }

    @Override
    public float getDmg() {
        return 7.0f;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

