/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;

public class LightningStaff
extends BaseStaff<BlockPos> {
    public LightningStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.COMPASS_RUNE.get(), 1);
        runes.put((Item)AoAItems.STRIKE_RUNE.get(), 4);
        runes.put((Item)AoAItems.STORM_RUNE.get(), 4);
    }

    @Override
    public BlockPos checkPreconditions(LivingEntity caster, ItemStack staff) {
        BlockPos trace = null;
        if (caster instanceof Player) {
            trace = PlayerUtil.getBlockAimingAt((Player)caster, 70.0);
        }
        return trace;
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, BlockPos args) {
        if (world instanceof ServerLevel) {
            for (int i = 0; i <= 360; i += 18) {
                double posX = (double)args.m_123341_() + Math.cos(i) * 4.0;
                double posZ = (double)args.m_123343_() + Math.sin(i) * 4.0;
                WorldUtil.spawnLightning((ServerLevel)world, caster instanceof ServerPlayer ? (ServerPlayer)caster : null, posX, world.m_5452_(Heightmap.Types.MOTION_BLOCKING, new BlockPos(posX, 0.0, posZ)).m_123342_(), posZ, true, false);
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

