/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sniper;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.GunRecoilPacket;
import net.tslat.aoa3.common.registration.AoACreativeModeTabs;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.entity.projectile.gun.SniperSlugEntity;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.LocaleUtil;

public abstract class BaseSniper
extends BaseGun {
    protected static final ResourceLocation SCOPE_1 = new ResourceLocation("aoa3", "textures/gui/overlay/scope/scope1.png");
    protected static final ResourceLocation SCOPE_2 = new ResourceLocation("aoa3", "textures/gui/overlay/scope/scope2.png");
    protected static final ResourceLocation SCOPE_3 = new ResourceLocation("aoa3", "textures/gui/overlay/scope/scope3.png");
    protected static final ResourceLocation SCOPE_4 = new ResourceLocation("aoa3", "textures/gui/overlay/scope/scope4.png");

    public BaseSniper(double dmg, int durability, int fireDelayTicks, float recoil) {
        super(AoACreativeModeTabs.SNIPERS, dmg, durability, fireDelayTicks, recoil);
    }

    @Override
    public Item getAmmoItem() {
        return (Item)AoAItems.METAL_SLUG.get();
    }

    @Override
    public boolean isFullAutomatic() {
        return false;
    }

    @Override
    protected boolean fireGun(LivingEntity shooter, ItemStack stack, InteractionHand hand) {
        BaseBullet bullet = this.findAndConsumeAmmo(shooter, stack, hand);
        if (bullet == null) {
            return false;
        }
        if (!shooter.m_20096_() || !shooter.m_6144_()) {
            bullet.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, 20.0f, 50.0f);
        }
        shooter.f_19853_.m_7967_((Entity)bullet);
        if (!shooter.f_19853_.m_5776_()) {
            this.doFiringEffects(shooter, bullet, stack, hand);
        }
        return true;
    }

    @Override
    public void doRecoil(ServerPlayer player, ItemStack stack, InteractionHand hand) {
        int control = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.CONTROL.get()), (ItemStack)stack);
        float recoilAmount = this.getRecoilForShot(stack, (LivingEntity)player) * 0.25f * (1.0f - (float)control * 0.15f);
        if (!player.m_6144_() || !player.m_20096_()) {
            recoilAmount *= 3.5f;
        }
        AoAPackets.messagePlayer(player, new GunRecoilPacket(recoilAmount, this.getFiringDelay()));
    }

    @Override
    public void doImpactDamage(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        super.doImpactDamage(target, shooter, bullet, bullet.getAge() <= 0 ? bulletDmgMultiplier * 0.5f : bulletDmgMultiplier);
    }

    @Override
    public BaseBullet createProjectileEntity(LivingEntity shooter, ItemStack gunStack, InteractionHand hand) {
        return new SniperSlugEntity(shooter, this, 0);
    }

    public ResourceLocation getScopeTexture(ItemStack stack) {
        return SCOPE_1;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.add(2, LocaleUtil.getFormattedItemDescriptionText("items.description.sniper.use", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
    }
}

