/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.shotgun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoACreativeModeTabs;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.entity.projectile.gun.LimoniteBulletEntity;
import net.tslat.aoa3.content.entity.projectile.gun.MetalSlugEntity;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;

public class BaseShotgun
extends BaseGun {
    protected final int pelletCount;
    protected final float knockbackFactor;

    public BaseShotgun(double dmg, int pellets, int durability, int fireDelayTicks, float knockbackFactor, float recoil) {
        super(AoACreativeModeTabs.SHOTGUNS, dmg, durability, fireDelayTicks, recoil);
        this.pelletCount = pellets;
        this.knockbackFactor = knockbackFactor;
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_SHOTGUN_MEDIUM_FIRE_LONG.get();
    }

    @Override
    public Item getAmmoItem() {
        return (Item)AoAItems.SPREADSHOT.get();
    }

    @Override
    public boolean isFullAutomatic() {
        return false;
    }

    public int getPelletCount() {
        return this.pelletCount;
    }

    @Override
    protected boolean fireGun(LivingEntity shooter, ItemStack stack, InteractionHand hand) {
        BaseBullet bullet = this.findAndConsumeAmmo(shooter, stack, hand);
        if (bullet == null) {
            return false;
        }
        int pellets = this.getPelletCount();
        float spreadFactor = 0.1f * (float)pellets * (1.0f - 0.15f * (float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.FORM.get()), (ItemStack)stack));
        for (int i = 0; i < pellets; ++i) {
            LimoniteBulletEntity pellet = new LimoniteBulletEntity(shooter, this, hand, 4, 1.0f, 0, RandomUtil.randomValueUpTo(0.5f) * spreadFactor, RandomUtil.randomValueUpTo(0.5f) * spreadFactor, RandomUtil.randomValueUpTo(0.5f) * spreadFactor);
            shooter.f_19853_.m_7967_((Entity)pellet);
        }
        if (!shooter.f_19853_.m_5776_()) {
            this.doFiringEffects(shooter, bullet, stack, hand);
        }
        return true;
    }

    @Override
    public BaseBullet createProjectileEntity(LivingEntity shooter, ItemStack gunStack, InteractionHand hand) {
        return new MetalSlugEntity(shooter, this, hand, 4, 0);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.set(1, LocaleUtil.getFormattedItemDescriptionText("items.description.damage.shotgun", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{Component.m_237113_((String)NumberUtil.roundToNthDecimalPlace((float)this.getDamage() * (1.0f + 0.1f * (float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.SHELL.get()), (ItemStack)stack)), 2)), LocaleUtil.numToComponent(this.pelletCount)}));
    }
}

