/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.gun;

import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.tslat.aoa3.common.registration.AoACreativeModeTabs;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.entity.projectile.gun.MetalSlugEntity;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;

public class BloodIron
extends BaseGun {
    public BloodIron(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(AoACreativeModeTabs.GUNS, dmg, durability, firingDelayTicks, recoil);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_CANNON_FIRE_1_LONG.get();
    }

    @Override
    protected float getFiringSoundPitchAdjust() {
        return 1.1f;
    }

    @Override
    public Item getAmmoItem() {
        return (Item)AoAItems.METAL_SLUG.get();
    }

    @Override
    public BaseBullet createProjectileEntity(LivingEntity shooter, ItemStack gunStack, InteractionHand hand) {
        return new MetalSlugEntity(shooter, this, hand, 120, 0);
    }
}

