/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.cannon;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoACreativeModeTabs;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.cannon.CannonballEntity;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;

public abstract class BaseCannon
extends BaseGun {
    public BaseCannon(double dmg, int durability, int fireDelayTicks, float recoil) {
        super(AoACreativeModeTabs.CANNONS, dmg, durability, fireDelayTicks, recoil);
    }

    @Override
    public Item getAmmoItem() {
        return (Item)AoAItems.CANNONBALL.get();
    }

    @Override
    public boolean isFullAutomatic() {
        return false;
    }

    @Override
    public void doImpactDamage(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target != null) {
            if (target instanceof LivingEntity) {
                bulletDmgMultiplier = (float)((double)bulletDmgMultiplier * (1.0 + ((LivingEntity)target).m_21051_(Attributes.f_22284_).m_22135_() * 1.5 / 100.0));
            }
            if (DamageUtil.dealGunDamage(target, shooter, bullet, (float)this.getDamage() * bulletDmgMultiplier)) {
                if (target instanceof Player && ((Player)target).m_21254_()) {
                    ((Player)target).m_36384_(true);
                }
                if (target instanceof LivingEntity) {
                    DamageUtil.doScaledKnockback((LivingEntity)target, (Entity)shooter, (float)this.getDamage() * bulletDmgMultiplier / 10.0f, shooter.m_20185_() - target.m_20185_(), shooter.m_20189_() - target.m_20189_());
                }
                this.doImpactEffect(target, shooter, bullet, bulletDmgMultiplier);
            }
        }
    }

    @Override
    public BaseBullet createProjectileEntity(LivingEntity shooter, ItemStack gunStack, InteractionHand hand) {
        return new CannonballEntity(shooter, this, hand, 120, 0);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.add(2, LocaleUtil.getFormattedItemDescriptionText("items.description.cannon.damage", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
    }
}

