/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.common.registration.AoACreativeModeTabs;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.data.server.AoAHaulingFishReloadListener;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;

public class ChumItem
extends Item {
    public ChumItem() {
        super(new Item.Properties().m_41491_(AoACreativeModeTabs.FOOD).m_41489_(new FoodProperties.Builder().m_38760_(1).m_38758_(0.1f).m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19604_, 60), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19614_, 60), 1.0f).m_38767_()));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player pPlayer, InteractionHand hand) {
        pPlayer.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)pPlayer.m_21120_(hand));
    }

    public int m_8105_(ItemStack stack) {
        return super.m_8105_(stack) + 3;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity user, int timeLeft) {
        if (!level.m_5776_() && this.m_8105_(stack) - timeLeft < 5) {
            if (!(user instanceof Player) || !((Player)user).m_7500_()) {
                stack.m_41774_(1);
            }
            Vec3 velocityVector = EntityUtil.getVelocityVectorForFacing((Entity)user).m_82542_(1.0, 1.5, 1.0);
            List<BlockPos> positions = WorldUtil.getBlocksWithinAABB(level, user.m_20191_().m_82386_(velocityVector.m_7096_() * 3.0, velocityVector.m_7098_() * 3.0, velocityVector.m_7094_() * 3.0), (blockState, mutable) -> blockState.m_60819_().m_205070_(FluidTags.f_13131_) && blockState.m_60819_().m_76155_((BlockGetter)level, (BlockPos)mutable) > 0.85f);
            if (!positions.isEmpty() && RandomUtil.oneInNChance(Math.max(100 / positions.size(), 1))) {
                BlockPos pos = RandomUtil.getRandomSelection(positions);
                Entity fish = this.getFishEntity(user, level, pos);
                fish.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                level.m_7967_(fish);
            }
            ServerParticlePacket packet = new ServerParticlePacket();
            ItemParticleOption particleData = new ItemParticleOption((ParticleType)AoAParticleTypes.FLOATING_ITEM_FRAGMENT.get(), stack);
            for (float i = -0.15f; i <= 0.15f; i += 0.05f) {
                packet.particle((ParticleOptions)particleData, user.m_20185_(), user.m_20186_() + (double)user.m_20192_(), user.m_20189_(), velocityVector.m_7096_() + (double)(i * 2.0f) * velocityVector.m_7094_(), velocityVector.m_7098_(), velocityVector.m_7094_() + (double)(i * 2.0f) * velocityVector.m_7096_());
            }
            AoAPackets.messageNearbyPlayers(packet, (ServerLevel)level, user.m_20182_(), 32.0);
        }
    }

    private Entity getFishEntity(LivingEntity user, Level world, BlockPos pos) {
        int selection;
        if (user instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)user;
            Entity entity = AoAHaulingFishReloadListener.getFishListForBiome((Biome)user.f_19853_.m_204166_(pos).m_203334_(), false).getRandomElement(player, player.m_36336_()).apply(user.f_19853_);
            if (!(entity instanceof ItemEntity)) {
                return entity;
            }
        }
        if ((selection = RandomUtil.randomNumberUpTo(66)) == 0) {
            return new Dolphin(EntityType.f_20559_, world);
        }
        if (selection <= 5) {
            return new Squid(EntityType.f_20480_, world);
        }
        if (selection <= 15) {
            return new Pufferfish(EntityType.f_20516_, world);
        }
        if (selection <= 30) {
            return new Cod(EntityType.f_20556_, world);
        }
        if (selection <= 45) {
            return new Salmon(EntityType.f_20519_, world);
        }
        return new TropicalFish(EntityType.f_20489_, world);
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> tooltip, TooltipFlag flags) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 1, new Component[0]));
    }
}

