/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;

public class VoidArmour
extends AdventArmour {
    public VoidArmour(EquipmentSlot slot) {
        super(ItemUtil.customArmourMaterial("aoa3:void", 25, new int[]{3, 6, 8, 3}, 10, SoundEvents.f_11675_, 2.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.VOID;
    }

    @Override
    public void onPostAttackReceived(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots, LivingDamageEvent event) {
        if ((slots == null || plData.equipment().getCurrentFullArmourSet() != this.setType()) && !plData.player().f_19853_.f_46443_ && event.getSource().m_7639_() instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)event.getSource().m_7639_();
            if (DamageUtil.isMeleeDamage(event.getSource())) {
                if (slots == null) {
                    if (RandomUtil.oneInNChance(5)) {
                        attacker.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 30, 20, true, true));
                    }
                } else if (RandomUtil.percentChance(0.025f * (float)slots.size())) {
                    attacker.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 30, 20, true, true));
                }
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.void_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.void_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

