/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public class EmbrodiumArmour
extends AdventArmour {
    public EmbrodiumArmour(EquipmentSlot slot) {
        super(ItemUtil.customArmourMaterial("aoa3:embrodium", 45, new int[]{4, 7, 8, 3}, 10, SoundEvents.f_11675_, 3.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.EMBRODIUM;
    }

    @Override
    public void onEffectTick(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots) {
        if (slots == null) {
            plData.getResource((AoAResource)AoAResources.SPIRIT.get()).addValue(0.08f);
        } else {
            ServerPlayer pl = plData.player();
            float temp = WorldUtil.getAmbientTemperature(pl.f_19853_, pl.m_20183_());
            if (temp > 0.8f) {
                plData.getResource((AoAResource)AoAResources.SPIRIT.get()).addValue(0.08f * (float)slots.size() * Math.min(1.0f, temp / 2.0f));
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.embrodium_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.embrodium_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

