/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.staff;

import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.tslat.aoa3.content.item.EnergyProjectileWeapon;

public abstract class BaseEnergyShot
extends ThrowableProjectile {
    protected int lifespan;
    private int age = 0;
    protected EnergyProjectileWeapon weapon;
    private Entity cachedOwner = null;

    public BaseEnergyShot(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public BaseEnergyShot(EntityType<? extends ThrowableProjectile> entityType, LivingEntity shooter, EnergyProjectileWeapon weapon, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        super(entityType, shooter.f_19853_);
        this.lifespan = 60;
        this.weapon = weapon;
        this.m_5602_((Entity)shooter);
        this.m_7678_(posX, posY, posZ, 0.0f, 360.0f);
        this.m_20256_(new Vec3(motionX, motionY, motionZ));
    }

    public BaseEnergyShot(EntityType<? extends ThrowableProjectile> entityType, Entity shooter, EnergyProjectileWeapon weapon, double posX, double posY, double posZ, float velocity) {
        super(entityType, shooter.f_19853_);
        this.lifespan = 120;
        this.weapon = weapon;
        this.m_5602_(shooter);
        this.m_7678_(posX, posY, posZ, 0.0f, 360.0f);
        this.m_20256_(new Vec3(this.f_19796_.m_188583_() / 33.0 + 0.03, (double)(-velocity), this.f_19796_.m_188583_() / 33.0 + 0.03));
    }

    public BaseEnergyShot(EntityType<? extends ThrowableProjectile> entityType, LivingEntity shooter, EnergyProjectileWeapon weapon, int maxAge, float xMod, float yMod, float zMod) {
        super(entityType, shooter.f_19853_);
        this.lifespan = maxAge;
        this.weapon = weapon;
        this.m_5602_((Entity)shooter);
        this.m_7678_(shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_(), shooter.m_20189_(), shooter.m_146908_(), shooter.m_146909_());
        boolean right = true;
        if (shooter instanceof Player) {
            if (weapon.getWeaponHand(shooter) == InteractionHand.MAIN_HAND) {
                if (shooter.m_5737_() == HumanoidArm.LEFT) {
                    right = false;
                }
            } else if (shooter.m_5737_() == HumanoidArm.RIGHT) {
                right = false;
            }
        }
        this.m_6686_((double)(-Mth.m_14031_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(this.m_146909_() / 180.0f * (float)Math.PI))) + (double)xMod, (double)(-Mth.m_14031_((float)(this.m_146909_() / 180.0f * (float)Math.PI))) + (double)yMod, (double)(Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(this.m_146909_() / 180.0f * (float)Math.PI))) + (double)zMod, 3.0f, 1.0f);
        if (right) {
            this.m_6034_(this.m_20184_().m_7096_() * 0.5 + this.m_20185_() - (double)(Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.4f), this.m_20184_().m_7098_() * 0.5 + this.m_20186_() - 0.3, this.m_20184_().m_7094_() * 0.5 + this.m_20189_() + (double)(Mth.m_14031_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.4f));
        } else {
            this.m_6034_(this.m_20184_().m_7096_() * 0.5 + this.m_20185_() + (double)(Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.4f), this.m_20184_().m_7098_() * 0.5 + this.m_20186_() - 0.3, this.m_20184_().m_7094_() * 0.5 + this.m_20189_() - (double)(Mth.m_14031_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.4f));
        }
    }

    public BaseEnergyShot(EntityType<? extends ThrowableProjectile> entityType, LivingEntity shooter, EnergyProjectileWeapon weapon, int maxAge) {
        super(entityType, shooter.f_19853_);
        boolean right;
        this.lifespan = maxAge;
        this.weapon = weapon;
        this.m_5602_((Entity)shooter);
        this.m_7678_(shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_(), shooter.m_20189_(), shooter.m_146908_(), shooter.m_146909_());
        boolean bl = right = shooter.m_5737_() == HumanoidArm.RIGHT;
        if (shooter instanceof Player) {
            if (weapon.getWeaponHand(shooter) == InteractionHand.MAIN_HAND) {
                if (shooter.m_5737_() == HumanoidArm.LEFT) {
                    right = false;
                }
            } else if (shooter.m_5737_() == HumanoidArm.RIGHT) {
                right = false;
            }
        }
        this.m_6686_(-Mth.m_14031_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(this.m_146909_() / 180.0f * (float)Math.PI)), -Mth.m_14031_((float)(this.m_146909_() / 180.0f * (float)Math.PI)), Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(this.m_146909_() / 180.0f * (float)Math.PI)), 3.0f, 1.0f);
        if (right) {
            this.m_6034_(this.m_20184_().m_7096_() * 0.5 + this.m_20185_() - (double)(Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.4f), this.m_20184_().m_7098_() * 0.5 + this.m_20186_() - 0.3, this.m_20184_().m_7094_() * 0.5 + this.m_20189_() + (double)(Mth.m_14031_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.4f));
        } else {
            this.m_6034_(this.m_20184_().m_7096_() * 0.5 + this.m_20185_() + (double)(Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.4f), this.m_20184_().m_7098_() * 0.5 + this.m_20186_() - 0.3, this.m_20184_().m_7094_() * 0.5 + this.m_20189_() - (double)(Mth.m_14031_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.4f));
        }
    }

    public BaseEnergyShot(EntityType<? extends ThrowableProjectile> entityType, Level world, double x, double y, double z) {
        super(entityType, world);
    }

    @Nullable
    public Entity m_37282_() {
        if (this.cachedOwner != null && this.cachedOwner.m_6084_()) {
            return this.cachedOwner;
        }
        this.cachedOwner = super.m_37282_();
        return this.cachedOwner;
    }

    protected void m_6532_(HitResult result) {
        if (!this.f_19853_.f_46443_) {
            Entity shooter;
            if (this.weapon != null && this.m_6084_() && (shooter = this.m_37282_()) instanceof LivingEntity) {
                if (result.m_6662_() == HitResult.Type.BLOCK) {
                    this.weapon.doBlockImpact(this, result.m_82450_(), (LivingEntity)shooter);
                } else if (result.m_6662_() == HitResult.Type.ENTITY) {
                    this.weapon.doEntityImpact(this, ((EntityHitResult)result).m_82443_(), (LivingEntity)shooter);
                }
            }
            this.m_146870_();
        }
    }

    protected void m_8097_() {
    }

    public boolean m_6128_() {
        return true;
    }

    public void m_8119_() {
        Vec3 velocityAdjustedPosition;
        if (!this.m_6084_()) {
            return;
        }
        Vec3 motion = this.m_20184_();
        Vec3 position = new Vec3(this.m_20185_() - motion.m_7096_() * 0.5, this.m_20186_() - motion.m_7098_() * 0.5, this.m_20189_() - motion.m_7094_() * 0.5);
        BlockHitResult collisionTrace = this.f_19853_.m_45547_(new ClipContext(position, velocityAdjustedPosition = new Vec3(this.m_20185_() + motion.m_7096_(), this.m_20186_() + motion.m_7098_(), this.m_20189_() + motion.m_7094_()), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, null));
        velocityAdjustedPosition = collisionTrace.m_6662_() != HitResult.Type.MISS ? new Vec3(collisionTrace.m_82450_().f_82479_, collisionTrace.m_82450_().f_82480_, collisionTrace.m_82450_().f_82481_) : new Vec3(this.m_20185_() + motion.m_7096_(), this.m_20186_() + motion.m_7098_(), this.m_20189_() + motion.m_7094_());
        Entity shooter = this.m_37282_();
        EntityHitResult entityTrace = ProjectileUtil.m_37304_((Level)this.f_19853_, (Entity)this, (Vec3)position, (Vec3)velocityAdjustedPosition, (AABB)this.m_20191_().m_82363_(motion.m_7096_(), motion.m_7098_(), motion.m_7094_()).m_82400_(0.5), entity -> entity.m_6084_() && entity.m_6087_() && !entity.m_5833_() && entity != shooter);
        if (entityTrace != null) {
            collisionTrace = entityTrace;
        }
        if (collisionTrace.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)collisionTrace)) {
            this.m_6532_((HitResult)collisionTrace);
        }
        this.f_19790_ = this.m_20185_();
        this.f_19791_ = this.m_20186_();
        this.f_19792_ = this.m_20189_();
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.age > this.lifespan) {
                this.m_146870_();
            } else {
                ++this.age;
            }
        }
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public int getAge() {
        return this.age;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

