/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.overworld;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.common.Tags;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.ai.mob.ExtendedFindNearbyTargetGoal;
import net.tslat.aoa3.content.entity.ai.mob.ExtendedMeleeAttackGoal;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.world.gen.BiomeMatcher;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.aoa3.library.object.CachedFunction;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.manager.AnimationData;

public class ChargerEntity
extends AoAMeleeMob {
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(ChargerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private Type type = null;

    public ChargerEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TYPE, (Object)Type.DEFAULT.name);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, new ExtendedMeleeAttackGoal<ChargerEntity>(this).attackInterval((IntProvider)ConstantInt.m_146483_((int)this.m_21304_())).speedModifier(1.125).actionTelegraphTicks(this.getPreAttackTime()).onStart(goal -> this.m_6858_(true)).onStop(goal -> this.m_6858_(false)));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new ExtendedFindNearbyTargetGoal<ChargerEntity>(this, true, EntityPredicate.SURVIVAL_PLAYER).searchRadius(16.0));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(world, difficulty, reason, spawnData, dataTag);
        if (world.m_5518_().m_75831_(this.m_20183_(), 0) == 0) {
            this.m_20088_().m_135381_(TYPE, (Object)Type.VOID.name);
        } else {
            Holder biome = world.m_204166_(this.m_20183_());
            for (Type type : Type.values()) {
                if (type == Type.DEFAULT || !type.canSpawnType(world.m_6018_(), this.m_20183_(), (Holder<Biome>)biome)) continue;
                this.m_20088_().m_135381_(TYPE, (Object)type.name);
                break;
            }
        }
        return spawnData;
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.85f;
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AoASounds.ENTITY_CHARGER_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_CHARGER_DEATH.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_CHARGER_HURT.get();
    }

    @Override
    protected int getAttackSwingDuration() {
        return 11;
    }

    @Override
    protected int getPreAttackTime() {
        return 7;
    }

    public Type chargerType() {
        if (this.type != null) {
            return this.type;
        }
        this.type = Type.fromString((String)this.m_20088_().m_135370_(TYPE));
        return this.type;
    }

    @Override
    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(AoAAnimations.genericWalkRunSwimIdleController(this));
        animationData.addAnimationController(AoAAnimations.genericAttackController(this, AoAAnimations.ATTACK_BITE));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("ChargerType", this.chargerType().name);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("ChargerType")) {
            Type type;
            this.type = type = Type.fromString(compound.m_128461_("ChargerType"));
            this.m_20088_().m_135381_(TYPE, (Object)type.name);
        }
    }

    protected ResourceLocation m_7582_() {
        return this.chargerType() == Type.VOID ? AdventOfAscension.id("entities/void_charger") : super.m_7582_();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Type implements IExtensibleEnum
    {
        DEFAULT("", null),
        DESERT("desert", level -> new BiomeMatcher.Builder((ServerLevel)level).mustBe(Tags.Biomes.IS_HOT).atLeastOneOf(Tags.Biomes.IS_SANDY).build()),
        HILL("hill", level -> new BiomeMatcher.Builder((ServerLevel)level).mustBe(Tags.Biomes.IS_MOUNTAIN).cannotBe(Tags.Biomes.IS_SNOWY).build()),
        SEA("sea", level -> new BiomeMatcher.Builder((ServerLevel)level).atLeastOneOf(BiomeTags.f_207603_, BiomeTags.f_207605_, BiomeTags.f_207604_).cannotBe(Tags.Biomes.IS_SNOWY).build()),
        SNOW("snow", level -> new BiomeMatcher.Builder((ServerLevel)level).mustBe(Tags.Biomes.IS_SNOWY).build()),
        SWAMP("swamp", level -> new BiomeMatcher.Builder((ServerLevel)level).mustBe(Tags.Biomes.IS_SWAMP).cannotBe(Tags.Biomes.IS_SNOWY).build()),
        VOID("void", null){

            @Override
            public boolean canSpawnType(ServerLevel level, BlockPos position, Holder<Biome> biome) {
                return level.m_45524_(position, 0) == 0;
            }
        };

        public final String name;
        @javax.annotation.Nullable
        private final CachedFunction<ServerLevel, BiomeMatcher> spawnBiomeMatcher;

        private Type(String prefix, Function<ServerLevel, BiomeMatcher> spawnBiomeMatcher) {
            this.name = prefix;
            this.spawnBiomeMatcher = spawnBiomeMatcher == null ? null : CachedFunction.of(spawnBiomeMatcher);
        }

        public boolean canSpawnType(ServerLevel level, BlockPos position, Holder<Biome> biome) {
            return this.spawnBiomeMatcher == null || ((BiomeMatcher)this.spawnBiomeMatcher.apply(level)).test(biome);
        }

        public static Type fromString(String typeName) {
            for (Type type : Type.values()) {
                if (!type.name.equals(typeName)) continue;
                return type;
            }
            return DEFAULT;
        }

        public static Type create(String name, String prefix, @javax.annotation.Nullable Function<ServerLevel, BiomeMatcher> spawnBiomeMatcher) {
            throw new IllegalStateException("Enum not extended");
        }
    }
}

