/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.tslat.aoa3.util.BrainUtils;
import net.tslat.aoa3.util.EntityUtil;

public class RetaliateOrTargetTask<E extends Mob>
extends Behavior<E> {
    private final Predicate<E> canAttackPredicate;
    private final Predicate<Entity> retaliationPredicate;
    private final Function<E, Optional<? extends LivingEntity>> targetFinder;
    private LivingEntity toTarget = null;

    public RetaliateOrTargetTask(E owner) {
        this(owner2 -> true, entity -> owner.m_5448_() == null && EntityUtil.Predicates.ATTACKABLE_ENTITY.test((Entity)entity), entity -> BrainUtils.getOptionalMemory((LivingEntity)owner, MemoryModuleType.f_148206_));
    }

    public RetaliateOrTargetTask(Predicate<E> canAttack, Predicate<Entity> shouldRetaliate, Function<E, Optional<? extends LivingEntity>> targetFinder) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26382_, (Object)MemoryStatus.REGISTERED));
        this.retaliationPredicate = shouldRetaliate;
        this.targetFinder = targetFinder;
        this.canAttackPredicate = canAttack;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, E owner) {
        if (!this.canAttackPredicate.test(owner)) {
            return false;
        }
        this.toTarget = this.targetFinder.apply(owner).orElse(null);
        if (this.toTarget != null) {
            return true;
        }
        this.toTarget = BrainUtils.getLastAttacker(owner);
        return this.toTarget != null && this.retaliationPredicate.test((Entity)this.toTarget);
    }

    protected void start(ServerLevel pLevel, E owner, long gameTime) {
        BrainUtils.setTargetOfEntity(owner, this.toTarget);
        BrainUtils.clearMemory(owner, MemoryModuleType.f_26326_);
        this.toTarget = null;
    }
}

