/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.RandomUtil;

public class CounterTargetWeaponTask
extends Behavior<Mob> {
    private final int minSwitchTime;
    private final int maxSwitchTime;
    private long nextSwitchTime = 0L;

    public CounterTargetWeaponTask() {
        this(10, 20);
    }

    public CounterTargetWeaponTask(int minSwitchTime, int maxSwitchTime) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT));
        this.minSwitchTime = minSwitchTime;
        this.maxSwitchTime = maxSwitchTime;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Mob owner) {
        LivingEntity target = (LivingEntity)owner.m_6274_().m_21952_(MemoryModuleType.f_26372_).get();
        if (!target.m_6084_()) {
            return false;
        }
        return this.nextSwitchTime == 0L || this.nextSwitchTime < owner.f_19853_.m_46467_();
    }

    protected void start(ServerLevel pLevel, Mob owner, long pGameTime) {
        LivingEntity target = (LivingEntity)owner.m_6274_().m_21952_(MemoryModuleType.f_26372_).get();
        switch (this.determineThreat((LivingEntity)owner, target)) {
            case MELEE: {
                this.handleMeleeThreat((LivingEntity)owner, target);
                break;
            }
            case RANGED: {
                this.handleRangedThreat((LivingEntity)owner, target);
                break;
            }
            case SHIELD: {
                this.handleShieldThreat((LivingEntity)owner, target);
                break;
            }
        }
        this.nextSwitchTime = RandomUtil.randomNumberBetween(this.minSwitchTime, this.maxSwitchTime);
    }

    protected ThreatType determineThreat(LivingEntity owner, LivingEntity target) {
        ItemStack mainHandItem = target.m_21120_(InteractionHand.MAIN_HAND);
        if (mainHandItem.m_41720_() instanceof ShieldItem || target.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof ShieldItem) {
            return ThreatType.SHIELD;
        }
        if (mainHandItem.m_41720_() instanceof SwordItem || EntityUtil.safelyGetAttributeValue(target, Attributes.f_22281_) > 5.0) {
            if (!(owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof SwordItem)) {
                return ThreatType.MELEE;
            }
            return ThreatType.NONE;
        }
        if (mainHandItem.m_41720_() instanceof BowItem || mainHandItem.m_41720_() instanceof BaseGun) {
            if (!(owner.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof ShieldItem)) {
                return ThreatType.RANGED;
            }
            return ThreatType.NONE;
        }
        return ThreatType.NONE;
    }

    protected void handleMeleeThreat(LivingEntity owner, LivingEntity target) {
        owner.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)AoAWeapons.HARVESTER_SWORD.get()));
        owner.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
    }

    protected void handleRangedThreat(LivingEntity owner, LivingEntity target) {
        owner.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)AoAWeapons.HARVESTER_SWORD.get()));
        owner.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_42740_));
    }

    protected void handleShieldThreat(LivingEntity owner, LivingEntity target) {
        owner.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)AoAWeapons.HORIZON_MAUL.get()));
        owner.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_42740_));
    }

    private static enum ThreatType {
        NONE,
        MELEE,
        RANGED,
        SHIELD;

    }
}

