/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.tslat.aoa3.content.entity.ai.mob.ExtendedMeleeAttackGoal;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public abstract class AoAMeleeMob
extends Monster
implements IAnimatable {
    protected static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(AoAMeleeMob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final AttributeModifier SLOW_FALLING = new AttributeModifier(UUID.fromString("A5B6CF2A-2F7C-31EF-9022-7C3E7D5E6ABA"), "Slow falling acceleration reduction", -0.07, AttributeModifier.Operation.ADDITION);
    protected static final EntityDataAccessor<Boolean> INVULNERABLE = SynchedEntityData.m_135353_(AoAMeleeMob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected boolean isSlipperyMovement = false;
    private final AnimationFactory animationFactory = new AnimationFactory((IAnimatable)this);

    protected AoAMeleeMob(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, new ExtendedMeleeAttackGoal<AoAMeleeMob>(this).attackInterval((IntProvider)ConstantInt.m_146483_((int)this.m_21304_())).actionTelegraphTicks(this.getPreAttackTime()).onStart(goal -> this.m_20115_(3, true)).onStop(goal -> this.m_20115_(3, false)));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ATTACK_STATE, (Object)0);
        this.m_20088_().m_135372_(INVULNERABLE, (Object)false);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.f_21364_ = reason == MobSpawnType.MOB_SUMMONED ? 0 : (int)(5.0 + (this.m_21133_(Attributes.f_22276_) + this.m_21133_(Attributes.f_22284_) * 1.75 + this.m_21133_(Attributes.f_22281_) * 2.0) / 10.0);
        return super.m_6518_(world, difficulty, reason, spawnData, dataTag);
    }

    protected abstract float m_6431_(Pose var1, EntityDimensions var2);

    @Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return null;
    }

    protected int getAttackSwingDuration() {
        return 6;
    }

    protected int getPreAttackTime() {
        return 0;
    }

    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        if (!blockState.m_60767_().m_76332_()) {
            BlockState state = this.f_19853_.m_8055_(pos.m_7494_());
            SoundType blockSound = state.m_60734_() == Blocks.f_50125_ ? state.getSoundType((LevelReader)this.f_19853_, pos, (Entity)this) : blockState.getSoundType((LevelReader)this.f_19853_, pos, (Entity)this);
            return blockSound.m_56776_();
        }
        return null;
    }

    protected void onAttack(Entity target) {
    }

    protected void onHit(DamageSource source, float amount) {
    }

    public void m_20331_(boolean isInvulnerable) {
        super.m_20331_(isInvulnerable);
        this.m_20088_().m_135381_(INVULNERABLE, (Object)isInvulnerable);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key.equals(INVULNERABLE)) {
            this.m_20331_((Boolean)this.m_20088_().m_135370_(INVULNERABLE));
        }
    }

    public int getAttackState() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_STATE);
    }

    public void setAttackState(int state) {
        this.m_20088_().m_135381_(ATTACK_STATE, (Object)state);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        SoundEvent stepSound = this.getStepSound(pos, blockIn);
        if (stepSound != null) {
            this.m_5496_(stepSound, 0.15f, 1.0f);
        }
    }

    public boolean m_7327_(Entity target) {
        if (super.m_7327_(target)) {
            this.onAttack(target);
            return true;
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            this.onHit(source, amount);
            return true;
        }
        return false;
    }

    protected boolean m_6125_() {
        return super.m_6125_() && this.f_21364_ > 0;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6142_() || this.m_6109_()) {
            boolean isFalling;
            AttributeInstance gravity = this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            boolean bl = isFalling = this.m_20184_().f_82480_ <= 0.0;
            if (isFalling && this.m_21023_(MobEffects.f_19591_)) {
                if (!gravity.m_22109_(SLOW_FALLING)) {
                    gravity.m_22118_(SLOW_FALLING);
                }
                this.f_19789_ = 0.0f;
            } else if (gravity.m_22109_(SLOW_FALLING)) {
                gravity.m_22130_(SLOW_FALLING);
            }
            double gravityValue = gravity.m_22135_();
            FluidState fluidState = this.f_19853_.m_6425_(this.m_20183_());
            if (this.m_20069_() && this.m_6129_() && !this.m_203441_(fluidState)) {
                double initialYPos = this.m_20186_();
                float drag = this.m_20142_() ? 0.9f : this.m_6108_();
                float swimMotionFactor = 0.02f;
                float depthStrider = EnchantmentHelper.m_44922_((LivingEntity)this);
                if (depthStrider > 3.0f) {
                    depthStrider = 3.0f;
                }
                if (!this.f_19861_) {
                    depthStrider *= 0.5f;
                }
                if (depthStrider > 0.0f) {
                    drag += (0.54600006f - drag) * depthStrider / 3.0f;
                    swimMotionFactor += (this.m_6113_() - swimMotionFactor) * depthStrider / 3.0f;
                }
                if (this.m_21023_(MobEffects.f_19593_)) {
                    drag = 0.96f;
                }
                this.m_19920_(swimMotionFactor *= (float)this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22135_(), travelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                Vec3 vector3d6 = this.m_20184_();
                if (this.f_19862_ && this.m_6147_()) {
                    vector3d6 = new Vec3(vector3d6.f_82479_, 0.2, vector3d6.f_82481_);
                }
                this.m_20256_(vector3d6.m_82542_((double)drag, (double)0.8f, (double)drag));
                Vec3 constrainedMotion = this.m_20994_(gravityValue, isFalling, this.m_20184_());
                this.m_20256_(constrainedMotion);
                if (this.f_19862_ && this.m_20229_(constrainedMotion.f_82479_, constrainedMotion.f_82480_ + (double)0.6f - this.m_20186_() + initialYPos, constrainedMotion.f_82481_)) {
                    this.m_20334_(constrainedMotion.f_82479_, 0.3f, constrainedMotion.f_82481_);
                }
            } else if (this.m_20077_() && this.m_6129_() && !this.m_203441_(fluidState)) {
                double originalYPos = this.m_20186_();
                this.m_19920_(0.02f, travelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (this.m_204036_(FluidTags.f_13132_) <= this.m_20204_()) {
                    this.m_20256_(this.m_20184_().m_82542_(0.5, (double)0.8f, 0.5));
                    Vec3 constrainedMotion = this.m_20994_(gravityValue, isFalling, this.m_20184_());
                    this.m_20256_(constrainedMotion);
                } else {
                    this.m_20256_(this.m_20184_().m_82490_(0.5));
                }
                if (!this.m_20068_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -gravityValue / 4.0, 0.0));
                }
                Vec3 newMotion = this.m_20184_();
                if (this.f_19862_ && this.m_20229_(newMotion.f_82479_, newMotion.f_82480_ + (double)0.6f - this.m_20186_() + originalYPos, newMotion.f_82481_)) {
                    this.m_20334_(newMotion.f_82479_, 0.3f, newMotion.f_82481_);
                }
            } else if (this.m_21255_()) {
                double newLateralMotion;
                double lateralMotionDiff;
                float lateralCollisionSpeed;
                Vec3 curMotion = this.m_20184_();
                if (curMotion.f_82480_ > -0.5) {
                    this.f_19789_ = 1.0f;
                }
                Vec3 lookVec = this.m_20154_();
                float normalizedPitch = this.m_146909_() * ((float)Math.PI / 180);
                double lookHypot = Math.sqrt(lookVec.f_82479_ * lookVec.f_82479_ + lookVec.f_82481_ * lookVec.f_82481_);
                double lateralMotion = curMotion.m_165924_();
                double lookVecLength = lookVec.m_82553_();
                float pitchRotation = Mth.m_14089_((float)normalizedPitch);
                pitchRotation = (float)((double)pitchRotation * (double)pitchRotation * Math.min(1.0, lookVecLength / 0.4));
                curMotion = this.m_20184_().m_82520_(0.0, gravityValue * (-1.0 + (double)pitchRotation * 0.75), 0.0);
                if (curMotion.f_82480_ < 0.0 && lookHypot > 0.0) {
                    double verticalVelocityAdjust = curMotion.f_82480_ * -0.1 * (double)pitchRotation;
                    curMotion = curMotion.m_82520_(lookVec.f_82479_ * verticalVelocityAdjust / lookHypot, verticalVelocityAdjust, lookVec.f_82481_ * verticalVelocityAdjust / lookHypot);
                }
                if (normalizedPitch < 0.0f && lookHypot > 0.0) {
                    double lateralVelocityAdjust = lateralMotion * (double)(-Mth.m_14031_((float)normalizedPitch)) * 0.04;
                    curMotion = curMotion.m_82520_(-lookVec.f_82479_ * lateralVelocityAdjust / lookHypot, lateralVelocityAdjust * 3.2, -lookVec.f_82481_ * lateralVelocityAdjust / lookHypot);
                }
                if (lookHypot > 0.0) {
                    curMotion = curMotion.m_82520_((lookVec.f_82479_ / lookHypot * lateralMotion - curMotion.f_82479_) * 0.1, 0.0, (lookVec.f_82481_ / lookHypot * lateralMotion - curMotion.f_82481_) * 0.1);
                }
                this.m_20256_(curMotion.m_82542_((double)0.99f, (double)0.98f, (double)0.99f));
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (this.f_19862_ && !this.f_19853_.f_46443_ && (lateralCollisionSpeed = (float)((lateralMotionDiff = lateralMotion - (newLateralMotion = this.m_20184_().m_165924_())) * 10.0 - 3.0)) > 0.0f) {
                    this.m_5496_(this.m_5896_((int)lateralCollisionSpeed), 1.0f, 1.0f);
                    this.m_6469_(DamageSource.f_19316_, lateralCollisionSpeed);
                }
                if (this.f_19861_ && !this.f_19853_.f_46443_) {
                    this.m_20115_(7, false);
                }
            } else {
                BlockPos standingPosition = this.m_20099_();
                float blockSlipperiness = this.f_19853_.m_8055_(this.m_20099_()).getFriction((LevelReader)this.f_19853_, this.m_20099_(), (Entity)this);
                float friction = this.f_19861_ ? blockSlipperiness * 0.91f : 0.91f;
                Vec3 newMotion = this.m_21074_(travelVector, blockSlipperiness);
                double verticalMotion = newMotion.f_82480_;
                if (this.isSlipperyMovement) {
                    friction *= 0.9f;
                }
                if (this.m_21023_(MobEffects.f_19620_)) {
                    verticalMotion += (0.05 * (double)(this.m_21124_(MobEffects.f_19620_).m_19564_() + 1) - newMotion.f_82480_) * 0.2;
                    this.f_19789_ = 0.0f;
                } else if (this.f_19853_.f_46443_ && !this.f_19853_.m_46805_(standingPosition)) {
                    verticalMotion = this.m_20186_() > 0.0 ? -0.1 : 0.0;
                } else if (!this.m_20068_()) {
                    verticalMotion -= gravityValue;
                }
                this.m_20334_(newMotion.f_82479_ * (double)friction, verticalMotion * (double)0.98f, newMotion.f_82481_ * (double)friction);
            }
        }
        this.m_21043_((LivingEntity)this, this instanceof FlyingAnimal);
    }

    public int m_21304_() {
        int time = this.getAttackSwingDuration();
        if (MobEffectUtil.m_19584_((LivingEntity)this)) {
            time -= 1 + MobEffectUtil.m_19586_((LivingEntity)this);
        }
        if (this.m_21023_(MobEffects.f_19599_)) {
            time += (1 + this.m_21124_(MobEffects.f_19599_).m_19564_()) * 2;
        }
        return time;
    }

    public void registerControllers(AnimationData animationData) {
    }

    public AnimationFactory getFactory() {
        return this.animationFactory;
    }
}

