/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.animal;

import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.ai.mob.RandomFlyingGoal;
import net.tslat.aoa3.content.entity.ai.movehelper.RoamingFlightMovementController;
import net.tslat.aoa3.content.entity.base.AoAAnimal;

public class MeganeuropsisEntity
extends AoAAnimal {
    private static final EntityDataAccessor<Boolean> LANDED = SynchedEntityData.m_135353_(MeganeuropsisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> START_LANDING_TICKS = SynchedEntityData.m_135353_(MeganeuropsisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Direction> LANDING_DIRECTION = SynchedEntityData.m_135353_(MeganeuropsisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Optional<UUID>> LANDED_PLAYER = SynchedEntityData.m_135353_(MeganeuropsisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private Player clientRidingPlayer = null;
    private int clientStartLandingTicks = 0;

    public MeganeuropsisEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new RoamingFlightMovementController((Mob)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LANDED, (Object)false);
        this.f_19804_.m_135372_(START_LANDING_TICKS, (Object)0);
        this.f_19804_.m_135372_(LANDING_DIRECTION, (Object)Direction.DOWN);
        this.f_19804_.m_135372_(LANDED_PLAYER, Optional.empty());
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new EntityAIMeganeuropsisLand(this));
        this.f_21345_.m_25352_(1, (Goal)new RandomFlyingGoal((Mob)this, true));
    }

    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 0.3125f;
    }

    public int getStartLandingTicks() {
        return this.f_19853_.f_46443_ ? this.clientStartLandingTicks : (Integer)this.f_19804_.m_135370_(START_LANDING_TICKS);
    }

    public boolean isLanded() {
        return (Boolean)this.f_19804_.m_135370_(LANDED);
    }

    public Direction getLandingDirection() {
        return (Direction)this.f_19804_.m_135370_(LANDING_DIRECTION);
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)AoASounds.ENTITY_MEGANEUROPSIS_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_MEGANEUROPSIS_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AoASounds.ENTITY_MEGANEUROPSIS_AMBIENT.get();
    }

    @Override
    protected void m_7355_(BlockPos pos, BlockState block) {
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean m_6147_() {
        return false;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (this.f_19853_.f_46443_ && key.equals(START_LANDING_TICKS)) {
            this.clientStartLandingTicks = this.f_19797_;
        }
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public void m_7023_(Vec3 motion) {
        if (this.isLanded()) {
            Player pl;
            if (this.f_19853_.f_46443_ && this.getLandingDirection() == Direction.DOWN && !this.m_20159_() && ((Optional)this.f_19804_.m_135370_(LANDED_PLAYER)).isPresent() && (pl = this.f_19853_.m_46003_((UUID)((Optional)this.f_19804_.m_135370_(LANDED_PLAYER)).get())) != null) {
                this.clientRidingPlayer = pl;
                this.m_7998_((Entity)this.clientRidingPlayer, false);
            }
            return;
        }
        if (this.f_19853_.f_46443_ && this.m_20159_() && this.clientRidingPlayer != null) {
            this.clientRidingPlayer = null;
            this.m_8127_();
        }
        if (this.m_20069_()) {
            this.m_19920_(0.02f, motion);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.8));
        } else if (this.m_20077_()) {
            this.m_19920_(0.02f, motion);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        } else {
            BlockState underState;
            BlockPos underPos;
            float friction = 0.91f;
            if (this.f_19861_) {
                underPos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20191_().f_82289_) - 1, Mth.m_14107_((double)this.m_20189_()));
                underState = this.f_19853_.m_8055_(underPos);
                friction = underState.m_60734_().getFriction(underState, (LevelReader)this.f_19853_, underPos, (Entity)this) * 0.91f;
            }
            this.m_19920_(this.f_19861_ ? 0.1f * (0.16277136f / (friction * friction * friction)) : 0.02f, motion);
            friction = 0.91f;
            if (this.f_19861_) {
                underPos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20191_().f_82289_) - 1, Mth.m_14107_((double)this.m_20189_()));
                underState = this.f_19853_.m_8055_(underPos);
                friction = underState.m_60734_().getFriction(underState, (LevelReader)this.f_19853_, underPos, (Entity)this) * 0.91f;
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)friction));
        }
        this.f_20923_ = this.f_20924_;
        double movedX = this.m_20189_() - this.f_19854_;
        double movedZ = this.m_20189_() - this.f_19856_;
        double totalMotion = Math.sqrt(movedX * movedX + movedZ * movedZ) * 4.0;
        if (totalMotion > 1.0) {
            totalMotion = 1.0;
        }
        this.f_20924_ = (float)((double)this.f_20924_ + (totalMotion - (double)this.f_20924_) * (double)0.4f);
        this.f_20925_ += this.f_20924_;
    }

    static /* synthetic */ PathNavigation access$200(MeganeuropsisEntity x0) {
        return x0.f_21344_;
    }

    private class EntityAIMeganeuropsisLand
    extends Goal {
        private final MeganeuropsisEntity taskOwner;
        private BlockPos landingPos = null;
        private Direction blockFace = null;
        private Player landingPlayer = null;

        public EntityAIMeganeuropsisLand(MeganeuropsisEntity creature) {
            this.taskOwner = creature;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            if (this.taskOwner.m_21188_() != null) {
                return false;
            }
            if (this.landingPos == null && this.landingPlayer == null && this.taskOwner.m_217043_().m_188501_() <= 0.01f) {
                if (MeganeuropsisEntity.this.f_19796_.m_188499_()) {
                    Player nearestPlayer = this.taskOwner.f_19853_.m_45924_(MeganeuropsisEntity.this.m_20185_(), MeganeuropsisEntity.this.m_20186_(), MeganeuropsisEntity.this.m_20189_(), 10.0, false);
                    if (nearestPlayer != null && !nearestPlayer.m_20160_()) {
                        this.taskOwner.f_21344_.m_26573_();
                        this.landingPlayer = nearestPlayer;
                        return true;
                    }
                } else {
                    for (int i = 0; i < 3; ++i) {
                        int x = (int)(this.taskOwner.m_20185_() + this.taskOwner.m_217043_().m_188583_() * 10.0);
                        int z = (int)(this.taskOwner.m_20189_() + this.taskOwner.m_217043_().m_188583_() * 10.0);
                        int y = this.taskOwner.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, new BlockPos((double)x, this.taskOwner.m_20186_(), (double)z)).m_123342_();
                        if (this.taskOwner.m_20186_() - (double)y > 10.0) continue;
                        if ((double)y > this.taskOwner.m_20186_()) {
                            return false;
                        }
                        this.taskOwner.f_21344_.m_26573_();
                        this.landingPos = new BlockPos(x, y, z);
                        this.blockFace = Direction.UP;
                        return true;
                    }
                }
            }
            return false;
        }

        public void m_8056_() {
            if (this.landingPos != null) {
                this.taskOwner.m_21573_().m_26519_((double)this.landingPos.m_123341_(), (double)(this.landingPos.m_123342_() + 1), (double)this.landingPos.m_123343_(), 1.0);
            } else if (this.landingPlayer != null) {
                this.taskOwner.m_21573_().m_5624_((Entity)this.landingPlayer, 1.0);
            }
        }

        public boolean m_8045_() {
            if (this.landingPos == null && (this.landingPlayer == null || !this.landingPlayer.m_6084_() || this.landingPlayer.m_20160_() && !this.landingPlayer.m_20363_((Entity)this.taskOwner)) || this.taskOwner.m_21188_() != null) {
                return false;
            }
            return !this.taskOwner.m_21573_().m_26571_() || this.taskOwner.getStartLandingTicks() > 0 && this.taskOwner.f_19797_ - this.taskOwner.getStartLandingTicks() < 240;
        }

        public void m_8037_() {
            BlockPos targetPos;
            BlockPos blockPos = targetPos = this.landingPos != null ? this.landingPos : this.landingPlayer.m_20183_().m_7494_();
            if (!this.taskOwner.isLanded()) {
                if (this.taskOwner.m_20183_().m_203198_((double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_()) <= 4.0) {
                    this.taskOwner.m_21573_().m_26573_();
                    Vec3 actualLandingLocation = this.getActualLandingLocation();
                    BlockPos actualLandingBlockPos = new BlockPos(actualLandingLocation);
                    if (this.taskOwner.f_19853_.m_8055_(actualLandingBlockPos).m_60812_((BlockGetter)this.taskOwner.f_19853_, actualLandingBlockPos) != Shapes.m_83040_()) {
                        this.landingPos = null;
                        this.landingPlayer = null;
                        return;
                    }
                    if (this.taskOwner.getStartLandingTicks() == 0) {
                        this.taskOwner.f_19804_.m_135381_(START_LANDING_TICKS, (Object)this.taskOwner.f_19797_);
                    }
                    if (this.taskOwner.m_20183_().m_203198_((double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_()) <= 1.0) {
                        double vecX = actualLandingLocation.f_82479_ - this.taskOwner.m_20185_();
                        double vecZ = actualLandingLocation.f_82481_ - this.taskOwner.m_20189_();
                        float rotYaw = (float)(Mth.m_14136_((double)vecZ, (double)vecX) * 57.29577951308232) - 90.0f;
                        this.taskOwner.m_7678_(actualLandingLocation.f_82479_, actualLandingLocation.f_82480_, actualLandingLocation.f_82481_, rotYaw, 0.0f);
                        this.taskOwner.f_19804_.m_135381_(LANDED, (Object)true);
                        if (this.landingPlayer != null) {
                            this.taskOwner.f_19804_.m_135381_(LANDING_DIRECTION, (Object)Direction.DOWN);
                            this.taskOwner.f_19804_.m_135381_(LANDED_PLAYER, Optional.of(this.landingPlayer.m_20148_()));
                            this.taskOwner.m_7998_((Entity)this.landingPlayer, true);
                        } else {
                            this.taskOwner.f_19804_.m_135381_(LANDING_DIRECTION, (Object)this.blockFace);
                        }
                    } else {
                        double vecX = (actualLandingLocation.f_82479_ - this.taskOwner.m_20185_()) * 0.5;
                        double vecZ = (actualLandingLocation.f_82481_ - this.taskOwner.m_20189_()) * 0.5;
                        double vecY = (actualLandingLocation.f_82480_ - this.taskOwner.m_20186_()) * 0.5;
                        this.taskOwner.m_6478_(MoverType.SELF, new Vec3(vecX, vecY, vecZ));
                    }
                }
            } else if (this.landingPlayer == null) {
                Vec3 actualLandingLocation = this.getActualLandingLocation();
                this.taskOwner.m_20256_(new Vec3(0.0, 0.0, 0.0));
                this.taskOwner.f_19864_ = true;
                this.taskOwner.m_6021_(actualLandingLocation.f_82479_, actualLandingLocation.f_82480_ - 0.5, actualLandingLocation.f_82481_);
            }
        }

        public void m_8041_() {
            this.landingPos = null;
            this.blockFace = null;
            this.landingPlayer = null;
            this.taskOwner.f_19804_.m_135381_(START_LANDING_TICKS, (Object)0);
            this.taskOwner.f_19804_.m_135381_(LANDED, (Object)false);
            this.taskOwner.f_19804_.m_135381_(LANDING_DIRECTION, (Object)Direction.DOWN);
            this.taskOwner.f_19804_.m_135381_(LANDED_PLAYER, Optional.empty());
            this.taskOwner.m_8127_();
        }

        private Vec3 getActualLandingLocation() {
            if (this.landingPlayer != null) {
                return new Vec3(this.landingPlayer.m_20185_(), this.landingPlayer.m_20186_() + (double)this.landingPlayer.m_20206_() + (double)this.taskOwner.m_20206_() + 0.1, this.landingPlayer.m_20189_());
            }
            switch (this.blockFace) {
                case NORTH: {
                    return new Vec3((double)this.landingPos.m_123341_() + 0.5, (double)this.landingPos.m_123342_() + 0.5, (double)this.landingPos.m_123343_() - (double)this.taskOwner.m_20205_() / 2.0);
                }
                case SOUTH: {
                    return new Vec3((double)this.landingPos.m_123341_() + 0.5, (double)this.landingPos.m_123342_() + 0.5, (double)(this.landingPos.m_123343_() + 1) + (double)this.taskOwner.m_20205_() / 2.0);
                }
                case EAST: {
                    return new Vec3((double)(this.landingPos.m_123341_() + 1) + (double)this.taskOwner.m_20205_() / 2.0, (double)this.landingPos.m_123342_() + 0.5, (double)this.landingPos.m_123343_() + 0.5);
                }
                case WEST: {
                    return new Vec3((double)this.landingPos.m_123341_() - (double)this.taskOwner.m_20205_() / 2.0, (double)this.landingPos.m_123342_() + 0.5, (double)this.landingPos.m_123343_() + 0.5);
                }
            }
            return new Vec3((double)this.landingPos.m_123341_() + 0.5, (double)this.landingPos.m_123342_() + 0.5, (double)this.landingPos.m_123343_() + 0.5);
        }
    }
}

