/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.mob;

import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.tslat.aoa3.content.entity.base.AoAFlyingMeleeMob;

public class FlyingMeleeAttackGoal
extends Goal {
    private final AoAFlyingMeleeMob taskOwner;
    private final float speedModifier;
    private final boolean retainTarget;
    private int attackCooldown = 0;
    private Path path;
    private int delayTicks;
    private double targetX;
    private double targetY;
    private double targetZ;

    public FlyingMeleeAttackGoal(AoAFlyingMeleeMob creature, float speed, boolean longMemory) {
        this.taskOwner = creature;
        this.speedModifier = speed;
        this.retainTarget = longMemory;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.taskOwner.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        this.path = this.taskOwner.m_21573_().m_6570_((Entity)target, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReach(target) >= this.taskOwner.m_20275_(target.m_20185_(), target.m_20191_().f_82289_, target.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity target = this.taskOwner.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (!this.retainTarget) {
            return !this.taskOwner.m_21573_().m_26571_();
        }
        return !(target instanceof Player) || !target.m_5833_() && !((Player)target).m_7500_();
    }

    public void m_8056_() {
        this.taskOwner.m_21573_().m_26536_(this.path, (double)this.speedModifier);
        this.delayTicks = 0;
    }

    public void m_8041_() {
        LivingEntity target = this.taskOwner.m_5448_();
        if (target instanceof Player && (target.m_5833_() || ((Player)target).m_7500_())) {
            this.taskOwner.m_6710_(null);
        }
        this.taskOwner.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity target = this.taskOwner.m_5448_();
        if (target == null) {
            this.m_8041_();
            return;
        }
        double attackDistance = this.taskOwner.m_20275_(target.m_20185_(), target.m_20191_().f_82289_, target.m_20189_());
        this.taskOwner.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        --this.delayTicks;
        if ((this.retainTarget || this.taskOwner.m_21574_().m_148306_((Entity)target)) && this.delayTicks <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || target.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.taskOwner.m_217043_().m_188501_() < 0.05f)) {
            this.targetX = target.m_20185_();
            this.targetY = target.m_20191_().f_82289_;
            this.targetZ = target.m_20189_();
            this.delayTicks = 4 + this.taskOwner.m_217043_().m_188503_(7);
            if (attackDistance > 1024.0) {
                this.delayTicks += 10;
            } else if (attackDistance < 256.0) {
                this.delayTicks += 5;
            }
            if (!this.taskOwner.m_21573_().m_5624_((Entity)target, (double)this.speedModifier)) {
                this.delayTicks += 15;
            } else {
                this.taskOwner.m_21566_().m_6849_(this.targetX, this.targetY, this.targetZ, (double)this.speedModifier);
            }
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        this.checkAndAttack(target, attackDistance);
    }

    private void checkAndAttack(LivingEntity target, double attackDistance) {
        double reach = this.getAttackReach(target);
        if (attackDistance <= reach & this.attackCooldown <= 0) {
            this.attackCooldown = 20;
            this.taskOwner.m_6674_(InteractionHand.MAIN_HAND);
            this.taskOwner.m_7327_((Entity)target);
        }
    }

    private double getAttackReach(LivingEntity target) {
        return (double)this.taskOwner.m_20205_() * 2.0 * (double)this.taskOwner.m_20205_() * 2.0 + (double)target.m_20205_();
    }
}

