/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.mob;

import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.GameRules;
import net.tslat.aoa3.content.entity.ai.ExtendedTargetGoal;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.aoa3.util.EntityRetrievalUtil;

public class ExtendedHurtByTargetGoal<T extends Mob>
extends ExtendedTargetGoal<T> {
    private static final TargetingConditions HURT_BY_TARGETING = TargetingConditions.m_148352_().m_148355_().m_26893_();
    private final Predicate<Entity> DEFAULT_ALLY_PREDICATE = entity -> {
        if (!(entity instanceof Mob)) return false;
        Mob mob = (Mob)entity;
        if (mob.m_5448_() != null) return false;
        if (mob.m_7307_((Entity)this.entity.m_21188_())) return false;
        Mob patt890$temp = this.entity;
        if (!(patt890$temp instanceof TamableAnimal)) return true;
        TamableAnimal animal = (TamableAnimal)patt890$temp;
        if (!(mob instanceof TamableAnimal)) return false;
        TamableAnimal tamableMob = (TamableAnimal)mob;
        if (animal.m_21826_() != tamableMob.m_21826_()) return false;
        return true;
    };
    private int lastHurtByTimestamp;
    private Predicate<Entity> targetableAttackerPredicate = entity -> true;
    private Predicate<Entity> alertableAllyPredicate = this.DEFAULT_ALLY_PREDICATE;
    private int alertRadius = -1;

    public ExtendedHurtByTargetGoal(T entity2) {
        super(entity2);
    }

    public ExtendedHurtByTargetGoal<T> onlyTargetWhen(Predicate<Entity> predicate) {
        this.targetableAttackerPredicate = predicate;
        return this;
    }

    public ExtendedHurtByTargetGoal<T> alertNearbyEntities() {
        return this.alertNearbyEntities(new EntityPredicate().is(this.entity.m_6095_()));
    }

    public ExtendedHurtByTargetGoal<T> alertNearbyEntities(Predicate<Entity> predicate) {
        return this.alertNearbyEntities((int)this.entity.m_21133_(Attributes.f_22277_), predicate);
    }

    public ExtendedHurtByTargetGoal<T> alertNearbyEntities(int radius) {
        return this.alertNearbyEntities(radius, new EntityPredicate().is(this.entity.m_6095_()));
    }

    public ExtendedHurtByTargetGoal<T> alertNearbyEntities(int radius, Predicate<Entity> predicate) {
        this.alertableAllyPredicate = predicate.and(this.DEFAULT_ALLY_PREDICATE);
        this.alertRadius = radius;
        return this;
    }

    @Override
    public boolean m_8036_() {
        if (!super.m_8036_()) {
            return false;
        }
        LivingEntity lastAttacker = this.entity.m_21188_();
        if (this.entity.m_21213_() == this.lastHurtByTimestamp || lastAttacker == null) {
            return false;
        }
        if (lastAttacker.m_6095_() == EntityType.f_20532_ && this.entity.f_19853_.m_46469_().m_46207_(GameRules.f_46127_)) {
            return false;
        }
        if (!this.targetableAttackerPredicate.test((Entity)lastAttacker)) {
            return false;
        }
        return this.isAttackable(lastAttacker, HURT_BY_TARGETING);
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.entity.m_6710_(this.entity.m_21188_());
        this.target = this.entity.m_5448_();
        this.lastHurtByTimestamp = this.entity.m_21213_();
        this.targetOccludedTime = 300;
        if (this.alertRadius > 0) {
            this.alertAllies();
        }
    }

    protected void alertAllies() {
        for (Entity entity : EntityRetrievalUtil.getEntities((Entity)this.entity, this.alertRadius, this.alertableAllyPredicate)) {
            ((Mob)entity).m_6710_(this.entity.m_21188_());
        }
    }
}

