/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.portal;

import java.util.Collection;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.particletype.PortalFloaterParticleType;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.block.functional.portal.PortalBlock;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class NowhereActivityPortal
extends PortalBlock {
    private static final EnumProperty<Activity> ACTIVITY = EnumProperty.m_61587_((String)"activity", Activity.class);

    public NowhereActivityPortal() {
        super(AoADimensions.NOWHERE.key, MaterialColor.f_76366_, 0);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(ACTIVITY, (Comparable)((Object)Activity.UTILITY)));
    }

    @Override
    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity.m_20202_() == null && !entity.m_20160_() && entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            if (pl.f_19818_ > 0) {
                pl.f_19818_ = 30;
                return;
            }
            pl.f_19818_ = 100;
            ((Activity)((Object)state.m_61143_(ACTIVITY))).teleport(pl);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVITY});
    }

    @Override
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        for (int i = 0; i < 4; ++i) {
            int colour;
            double posXStart = (float)pos.m_123341_() + rand.m_188501_();
            double posYStart = (float)pos.m_123342_() + rand.m_188501_();
            double posZStart = (float)pos.m_123343_() + rand.m_188501_();
            double motionX = ((double)rand.m_188501_() - 0.5) * 0.5;
            double motionY = ((double)rand.m_188501_() - 0.5) * 0.5;
            double motionZ = ((double)rand.m_188501_() - 0.5) * 0.5;
            int randomMod = rand.m_188503_(2) * 2 - 1;
            switch ((Activity)((Object)state.m_61143_(ACTIVITY))) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case PARKOUR: {
                    int n = 39103;
                    break;
                }
                case PARKOUR_1: {
                    int n = 9175295;
                    break;
                }
                case PARKOUR_2: {
                    int n = 262388;
                    break;
                }
                case PARKOUR_3: {
                    int n = 12449536;
                    break;
                }
                case PARKOUR_4: {
                    int n = 0xFFCC00;
                    break;
                }
                case PARKOUR_5: {
                    int n = 14711552;
                    break;
                }
                case PARKOUR_6: {
                    int n = 0xD30000;
                    break;
                }
                case BOSSES: {
                    int n = 0xBA0000;
                    break;
                }
                case DUNGEON: {
                    int n = 9502944;
                    break;
                }
                case UTILITY: {
                    int n = 29210;
                    break;
                }
                case RETURN: {
                    int n = colour = 0xFFFFFF;
                }
            }
            if (world.m_8055_(pos.m_122024_()).m_60734_() != this && world.m_8055_(pos.m_122029_()).m_60734_() != this) {
                posXStart = (double)pos.m_123341_() + 0.5 + 0.25 * (double)randomMod;
                motionX = rand.m_188501_() * 2.0f * (float)randomMod;
            } else {
                posZStart = (double)pos.m_123343_() + 0.5 + 0.25 * (double)randomMod;
                motionZ = rand.m_188501_() * 2.0f * (float)randomMod;
            }
            world.m_7106_((ParticleOptions)new PortalFloaterParticleType.Data(new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), colour), posXStart, posYStart, posZStart, motionX, motionY, motionZ);
        }
    }

    public static enum Activity implements StringRepresentable
    {
        PARKOUR(21.5, 10.5, 22.0, 90.0f, pl -> {
            ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
            for (NonNullList inv : pl.m_150109_().f_35979_) {
                plData.storeItems((Collection<ItemStack>)inv);
            }
            pl.m_150109_().m_6211_();
        }),
        PARKOUR_1(0.0, 0.0, 0.0, -90.0f, pl -> ItemUtil.givePlayerItemOrDrop((Player)pl, new ItemStack((ItemLike)AoAItems.RETURN_CRYSTAL.get()))),
        PARKOUR_2(0.0, 0.0, 0.0, -90.0f, pl -> ItemUtil.givePlayerItemOrDrop((Player)pl, new ItemStack((ItemLike)AoAItems.RETURN_CRYSTAL.get()))),
        PARKOUR_3(0.0, 0.0, 0.0, -90.0f, pl -> ItemUtil.givePlayerItemOrDrop((Player)pl, new ItemStack((ItemLike)AoAItems.RETURN_CRYSTAL.get()))),
        PARKOUR_4(0.0, 0.0, 0.0, -90.0f, pl -> ItemUtil.givePlayerItemOrDrop((Player)pl, new ItemStack((ItemLike)AoAItems.RETURN_CRYSTAL.get()))),
        PARKOUR_5(0.0, 0.0, 0.0, -90.0f, pl -> ItemUtil.givePlayerItemOrDrop((Player)pl, new ItemStack((ItemLike)AoAItems.RETURN_CRYSTAL.get()))),
        PARKOUR_6(0.0, 0.0, 0.0, -90.0f, pl -> ItemUtil.givePlayerItemOrDrop((Player)pl, new ItemStack((ItemLike)AoAItems.RETURN_CRYSTAL.get()))),
        BOSSES(17.5, 502.5, 3.5, 0.0f),
        DUNGEON(6.5, 1501.5, 16.5, -90.0f),
        UTILITY(25.5, 1001.5, 16.0, 90.0f),
        RETURN(6.5, 1501.5, 16.5, -90.0f, pl -> {
            ItemUtil.clearInventoryOfItems((Player)pl, new ItemStack((ItemLike)AoAItems.RETURN_CRYSTAL.get()));
            PlayerUtil.getAdventPlayer(pl).returnItemStorage();
            PlayerUtil.resetToDefaultStatus(pl);
        });

        private final Vec3 teleportPos;
        private final float teleportRot;
        private final Consumer<ServerPlayer> useFunction;

        private Activity(double x, double y, @Nullable double z, float rot, Consumer<ServerPlayer> useFunction) {
            this.teleportPos = new Vec3(x, y, z);
            this.teleportRot = rot;
            this.useFunction = useFunction;
        }

        private Activity(double x, double y, double z, float rot) {
            this(x, y, z, rot, null);
        }

        public String m_7912_() {
            return this.toString().toLowerCase(Locale.ROOT);
        }

        public Vec3 getPos() {
            return this.teleportPos;
        }

        public void onUse(ServerPlayer pl) {
            if (this.useFunction != null) {
                this.useFunction.accept(pl);
            }
        }

        public void teleport(ServerPlayer pl) {
            if (this.teleportPos.m_82556_() == 0.0) {
                return;
            }
            AoAScheduler.scheduleSyncronisedTask(() -> {
                pl.f_8906_.m_9774_(this.teleportPos.f_82479_, this.teleportPos.f_82480_, this.teleportPos.f_82481_, this.teleportRot, pl.m_146909_());
                this.onUse(pl);
            }, 1);
        }
    }
}

