/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.plant;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.tslat.aoa3.content.block.functional.plant.CropBlock;

public abstract class MultiBlockCrop
extends CropBlock {
    public IntegerProperty HEIGHT = null;
    public IntegerProperty f_52244_ = null;
    private final VoxelShape[][] SHAPES;

    public MultiBlockCrop(MaterialColor colour, Supplier<Item> seedItem) {
        super(colour, seedItem);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)this.getHeightProperty(), (Comparable)Integer.valueOf(0)));
        this.SHAPES = new VoxelShape[this.getGrowthHeight()][this.stagesPerBlock()];
        this.populateShapes(this.SHAPES);
    }

    protected abstract void populateShapes(VoxelShape[][] var1);

    public int getGrowthHeight() {
        return 3;
    }

    public int stagesPerBlock() {
        return 5;
    }

    public IntegerProperty getHeightProperty() {
        if (this.HEIGHT != null) {
            return this.HEIGHT;
        }
        this.HEIGHT = IntegerProperty.m_61631_((String)"height", (int)0, (int)(this.getGrowthHeight() - 1));
        return this.HEIGHT;
    }

    public IntegerProperty m_7959_() {
        if (this.f_52244_ != null) {
            return this.f_52244_;
        }
        this.f_52244_ = IntegerProperty.m_61631_((String)"age", (int)0, (int)(this.stagesPerBlock() * this.getGrowthHeight() - 1));
        return this.f_52244_;
    }

    public int m_7419_() {
        return this.getGrowthHeight() * this.stagesPerBlock() - 1;
    }

    public boolean isMaxAgeForPart(BlockState state) {
        return (Integer)state.m_61143_((Property)this.m_7959_()) >= this.stagesPerBlock() * (1 + (Integer)state.m_61143_((Property)this.getHeightProperty())) - 1;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int height = (Integer)state.m_61143_((Property)this.getHeightProperty());
        int relativeGrowth = Mth.m_14045_((int)((Integer)state.m_61143_((Property)this.m_7959_()) - ((Integer)state.m_61143_((Property)this.getHeightProperty()) * (this.stagesPerBlock() - 1) + 1)), (int)0, (int)(this.stagesPerBlock() - 1));
        return this.SHAPES[height][relativeGrowth];
    }

    protected boolean m_6266_(BlockState state, BlockGetter world, BlockPos pos) {
        return state.m_60734_() == this && this.isMaxAgeForPart(state) || state.m_60734_() instanceof FarmBlock;
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        if (state.m_60734_() == this) {
            return (Integer)state.m_61143_((Property)this.getHeightProperty()) < this.getGrowthHeight() && this.isMaxAgeForPart(state);
        }
        return super.canSustainPlant(state, world, pos, facing, plantable);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if ((Integer)state.m_61143_((Property)this.m_7959_()) >= (1 + (Integer)state.m_61143_((Property)this.getHeightProperty())) * this.stagesPerBlock() && world.m_8055_(pos.m_7494_()).m_60734_() != this) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, facing, facingState, world, pos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (!super.m_7898_(state, world, pos)) {
            return false;
        }
        for (int i = 1; i < this.getGrowthHeight() + 1 && pos.m_123342_() - i >= 0; ++i) {
            BlockState testState = world.m_8055_(pos.m_6625_(i));
            if (testState.m_60734_() instanceof FarmBlock) {
                return true;
            }
            if (testState.m_60734_() == this && this.isMaxAgeForPart(testState)) continue;
            return false;
        }
        return false;
    }

    public void m_52263_(Level world, BlockPos pos, BlockState state) {
        this.growDown(world, pos, state);
    }

    public boolean m_7370_(BlockGetter world, BlockPos pos, BlockState state, boolean pIsClient) {
        if (this.m_52307_(state)) {
            return false;
        }
        if (!this.isMaxAgeForPart(state)) {
            return true;
        }
        while ((state = world.m_8055_(pos = pos.m_7494_())).m_60734_() == this) {
        }
        return state.m_60795_();
    }

    protected int m_7125_(Level pLevel) {
        return 1;
    }

    public void m_214148_(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
        while ((Integer)state.m_61143_((Property)this.m_7959_()) > (1 + (Integer)state.m_61143_((Property)this.getHeightProperty())) * this.stagesPerBlock() - 1) {
            state = world.m_8055_(pos = pos.m_7494_());
            if (state.m_60734_() == this) continue;
            return;
        }
        this.m_52263_((Level)world, pos, state);
    }

    public boolean m_6724_(BlockState state) {
        int age = (Integer)state.m_61143_((Property)this.m_7959_());
        if (age == this.m_7419_()) {
            return false;
        }
        return age <= this.stagesPerBlock() * (1 + (Integer)state.m_61143_((Property)this.getHeightProperty())) - 1;
    }

    protected void growDown(Level world, BlockPos pos, BlockState currentState) {
        int age = this.m_52305_(currentState);
        int height = (Integer)currentState.m_61143_((Property)this.getHeightProperty());
        BlockState agedState = this.m_52289_(age + 1);
        if (this.isMaxAgeForPart(currentState) && height < this.getGrowthHeight() - 1 && world.m_46859_(pos.m_7494_())) {
            world.m_7731_(pos.m_7494_(), (BlockState)agedState.m_61124_((Property)this.getHeightProperty(), (Comparable)Integer.valueOf(height + 1)), 3);
        }
        for (int i = 0; i <= height; ++i) {
            BlockPos newPos = pos.m_6625_(i);
            if (world.m_8055_(newPos).m_60734_() != this) continue;
            world.m_7731_(newPos, (BlockState)agedState.m_61124_((Property)this.getHeightProperty(), (Comparable)Integer.valueOf(height - i)), 3);
        }
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        if (world.m_8055_(pos.m_7494_()).m_60734_() == this) {
            return;
        }
        if (!this.m_52307_(state) && world.m_45524_(pos, 0) >= 9) {
            float growthSpeed;
            int age = this.m_52305_(state);
            int height = (Integer)state.m_61143_((Property)this.getHeightProperty());
            if (age <= this.stagesPerBlock() * (1 + height) - 1 && ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (rand.m_188503_((int)(25.0f / (growthSpeed = MultiBlockCrop.m_52272_((Block)this, (BlockGetter)world, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
                this.growDown((Level)world, pos, state);
                ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.m_7959_()}).m_61104_(new Property[]{this.getHeightProperty()});
    }
}

