/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.plant;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.tslat.aoa3.content.block.functional.plant.CropBlock;

public abstract class HangingCropBlock
extends CropBlock {
    public HangingCropBlock(MaterialColor colour, Supplier<Item> seedItem) {
        super(colour, seedItem);
    }

    protected boolean m_6266_(BlockState state, BlockGetter world, BlockPos pos) {
        return state.m_204336_(BlockTags.f_13035_);
    }

    @Override
    public abstract VoxelShape m_5940_(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        float growthMod;
        int age;
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        if (world.m_45524_(pos, 0) >= 9 && (age = this.m_52305_(state)) < this.m_7419_() && ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)(25.0f / (growthMod = this.getGrowthMod((Block)this, (BlockGetter)world, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            world.m_7731_(pos, this.m_52289_(age + 1), 2);
            ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public float getGrowthMod(Block block, BlockGetter level, BlockPos pos) {
        boolean longitudeAdjacent;
        float modifier = 1.0f;
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                float adjacentMod = 0.0f;
                BlockState blockstate = level.m_8055_((BlockPos)testPos.m_122178_(pos.m_123341_() + x, pos.m_123342_() + 1, pos.m_123343_() + z));
                if (blockstate.canSustainPlant(level, (BlockPos)testPos, Direction.DOWN, (IPlantable)block)) {
                    adjacentMod = 1.0f;
                    if (blockstate.isFertile(level, (BlockPos)testPos.m_122173_(Direction.DOWN))) {
                        adjacentMod = 3.0f;
                    }
                }
                if (x != 0 || z != 0) {
                    adjacentMod /= 4.0f;
                }
                modifier += adjacentMod;
            }
        }
        BlockPos eastPos = pos.m_122024_();
        BlockPos westPos = pos.m_122029_();
        boolean latitudeAdjacent = block == level.m_8055_(eastPos).m_60734_() || block == level.m_8055_(westPos).m_60734_();
        boolean bl = longitudeAdjacent = block == level.m_8055_(pos.m_122012_()).m_60734_() || block == level.m_8055_(pos.m_122019_()).m_60734_();
        if (latitudeAdjacent && longitudeAdjacent) {
            modifier /= 2.0f;
        } else if (block == level.m_8055_(eastPos.m_122012_()).m_60734_() || block == level.m_8055_(westPos.m_122012_()).m_60734_() || block == level.m_8055_(westPos.m_122019_()).m_60734_() || block == level.m_8055_(eastPos.m_122019_()).m_60734_()) {
            modifier /= 2.0f;
        }
        return modifier;
    }

    public boolean m_7898_(BlockState pState, LevelReader world, BlockPos pos) {
        BlockPos leafPos = pos.m_7494_();
        return this.m_6266_(world.m_8055_(leafPos), (BlockGetter)world, leafPos);
    }
}

