/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.altar;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.PlayerUtil;

public abstract class BossAltarBlock
extends Block {
    public BossAltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BossAltarBlock(MaterialColor mapColour) {
        this(new BlockUtil.CompactProperties(Material.f_76278_, mapColour).stats(35.0f, 1000.0f).get());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (this.getActivationItem() != null && heldItem.m_41720_() != this.getActivationItem()) {
            return InteractionResult.PASS;
        }
        if (player instanceof ServerPlayer && (this.getActivationItem() == null || heldItem.m_41720_() == this.getActivationItem())) {
            if (world.m_46791_() == Difficulty.PEACEFUL) {
                PlayerUtil.notifyPlayer(player, (Component)Component.m_237115_((String)"message.feedback.spawnBoss.difficultyFail"));
                return InteractionResult.FAIL;
            }
            if (this.checkActivationConditions(player, hand, state, pos)) {
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                }
                this.doActivationEffect(player, hand, state, pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    protected abstract Item getActivationItem();

    protected abstract void doActivationEffect(Player var1, InteractionHand var2, BlockState var3, BlockPos var4);

    protected boolean checkActivationConditions(Player player, InteractionHand hand, BlockState state, BlockPos pos) {
        return true;
    }

    protected void sendSpawnMessage(Player player, MutableComponent msg, BlockPos pos) {
        PlayerUtil.messageAllPlayersInRange((Component)msg, player.f_19853_, pos, 50);
    }
}

