/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import java.io.File;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import net.tslat.aoa3.config.ClientConfig;
import net.tslat.aoa3.config.CommonConfig;
import net.tslat.aoa3.config.IntegrationsConfig;
import net.tslat.aoa3.config.ServerConfig;
import org.apache.commons.lang3.tuple.Pair;

public final class AoAConfigs {
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_CONFIG_SPEC;
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_CONFIG_SPEC;
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_CONFIG_SPEC;
    public static final IntegrationsConfig INTEGRATIONS;
    public static final ForgeConfigSpec INTEGRATIONS_CONFIG_SPEC;

    public static void init() {
        FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get().resolve("aoa3"), (String)"aoa3");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG_SPEC, "aoa3_server_config.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_CONFIG_SPEC, "aoa3" + File.separator + "common_config.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_CONFIG_SPEC, "aoa3" + File.separator + "client_config.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)INTEGRATIONS_CONFIG_SPEC, "aoa3" + File.separator + "integrations_config.toml");
    }

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        Pair integrationSpecPair = new ForgeConfigSpec.Builder().configure(IntegrationsConfig::new);
        CLIENT_CONFIG_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (ClientConfig)clientSpecPair.getLeft();
        COMMON_CONFIG_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (CommonConfig)commonSpecPair.getLeft();
        SERVER_CONFIG_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER = (ServerConfig)serverSpecPair.getLeft();
        INTEGRATIONS_CONFIG_SPEC = (ForgeConfigSpec)integrationSpecPair.getRight();
        INTEGRATIONS = (IntegrationsConfig)integrationSpecPair.getLeft();
    }
}

