/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;

public class ToastPopupPacket
implements AoAPacket {
    private final ToastPopupType type;
    private final Object subject;
    private final Object value;

    public ToastPopupPacket(AoASkill skill, int levelReq) {
        this.type = ToastPopupType.SKILL_REQUIREMENT;
        this.value = levelReq;
        this.subject = AoARegistries.AOA_SKILLS.getId(skill);
    }

    public ToastPopupPacket(AoAResource resource, float amount) {
        this.type = ToastPopupType.RESOURCE_REQUIREMENT;
        this.value = Float.valueOf(amount);
        this.subject = AoARegistries.AOA_RESOURCES.getId(resource);
    }

    public ToastPopupPacket(AoASkill skill, AoAAbility ability) {
        this.type = ToastPopupType.ABILITY_UNLOCK;
        this.value = AoARegistries.AOA_ABILITIES.getId(ability);
        this.subject = AoARegistries.AOA_SKILLS.getId(skill);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.type.toString());
        switch (this.type) {
            case SKILL_REQUIREMENT: {
                buffer.m_130070_(this.subject.toString());
                buffer.writeInt(((Integer)this.value).intValue());
                break;
            }
            case RESOURCE_REQUIREMENT: {
                buffer.m_130070_(this.subject.toString());
                buffer.writeFloat(((Float)this.value).floatValue());
                break;
            }
            case ABILITY_UNLOCK: {
                buffer.m_130070_(this.subject.toString());
                buffer.m_130070_(this.value.toString());
            }
        }
    }

    public static ToastPopupPacket decode(FriendlyByteBuf buffer) {
        ToastPopupType type = ToastPopupType.valueOf(buffer.m_130136_(Short.MAX_VALUE));
        switch (type) {
            case SKILL_REQUIREMENT: {
                return new ToastPopupPacket(AoASkills.getSkill(new ResourceLocation(buffer.m_130136_(Short.MAX_VALUE))), buffer.readInt());
            }
            case RESOURCE_REQUIREMENT: {
                return new ToastPopupPacket(AoAResources.getResource(new ResourceLocation(buffer.m_130136_(Short.MAX_VALUE))), buffer.readFloat());
            }
            case ABILITY_UNLOCK: {
                return new ToastPopupPacket(AoASkills.getSkill(new ResourceLocation(buffer.m_130136_(Short.MAX_VALUE))), AoAAbilities.getAbility(new ResourceLocation(buffer.m_130136_(Short.MAX_VALUE))));
            }
        }
        return null;
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientOperations.addToast(this.type, this.subject, this.value));
        context.get().setPacketHandled(true);
    }

    public static enum ToastPopupType {
        SKILL_REQUIREMENT,
        RESOURCE_REQUIREMENT,
        ABILITY_UNLOCK;

    }
}

