/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.util.RandomUtil;

public class ServerParticlePacket
implements AoAPacket {
    private final ArrayList<ParticleData> particles = new ArrayList(1);
    private final boolean longRange;

    public ServerParticlePacket() {
        this(false);
    }

    public ServerParticlePacket(boolean longRange) {
        this.longRange = longRange;
    }

    public ServerParticlePacket particle(ParticleOptions particle, Entity entity) {
        return this.particle(particle, entity, false);
    }

    public ServerParticlePacket particle(ParticleOptions particle, Entity entity, boolean randomPosInBB) {
        if (randomPosInBB) {
            return this.particle(particle, entity.m_20185_() + (double)RandomUtil.randomValueUpTo(entity.m_20205_()), entity.m_20186_() + (double)RandomUtil.randomValueUpTo(entity.m_20206_()), entity.m_20189_() + (double)RandomUtil.randomValueUpTo(entity.m_20205_()));
        }
        return this.particle(particle, entity, 0.0, 0.0, 0.0);
    }

    public ServerParticlePacket particle(ParticleOptions particle, Entity entity, boolean randomPosInBB, double velX, double velY, double velZ) {
        return this.particle(particle, entity, randomPosInBB, velX, velY, velZ, 1);
    }

    public ServerParticlePacket particle(ParticleOptions particle, Entity entity, boolean randomPosInBB, double velX, double velY, double velZ, int amount) {
        return this.particle(particle, entity, randomPosInBB, velX, velY, velZ, amount, 1);
    }

    public ServerParticlePacket particle(ParticleOptions particle, Entity entity, boolean randomPosInBB, double velX, double velY, double velZ, int amountPerParticle, int particlesToGen) {
        for (int i = 0; i < particlesToGen; ++i) {
            if (randomPosInBB) {
                this.particle(particle, entity.m_20185_() + (double)RandomUtil.randomValueUpTo(entity.m_20205_()), entity.m_20186_() + (double)RandomUtil.randomValueUpTo(entity.m_20206_()), entity.m_20189_() + (double)RandomUtil.randomValueUpTo(entity.m_20205_()), velX, velY, velZ, amountPerParticle);
                continue;
            }
            this.particle(particle, entity, velX, velY, velZ);
        }
        return this;
    }

    public ServerParticlePacket particle(ParticleOptions particle, Entity entity, double velX, double velY, double velZ) {
        return this.particle(particle, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), velX, velY, velZ, 1);
    }

    public ServerParticlePacket particle(ParticleOptions particle, Entity entity, double velX, double velY, double velZ, int amount) {
        return this.particle(particle, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), velX, velY, velZ, amount);
    }

    public ServerParticlePacket particle(ParticleOptions particle, double x, double y, double z) {
        return this.particle(particle, x, y, z, 1);
    }

    public ServerParticlePacket particle(ParticleOptions particle, double x, double y, double z, int amount) {
        return this.particle(particle, x, y, z, 0.0, 0.0, 0.0, amount);
    }

    public ServerParticlePacket particle(ParticleOptions particle, double x, double y, double z, double velX, double velY, double velZ) {
        return this.particle(particle, x, y, z, velX, velY, velZ, 1);
    }

    public ServerParticlePacket particle(ParticleOptions particle, double x, double y, double z, double velX, double velY, double velZ, int amount) {
        this.particles.add(new ParticleData(particle, x, y, z, velX, velY, velZ, amount));
        return this;
    }

    public boolean isLongRange() {
        return this.longRange;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.particles.size());
        for (ParticleData data : this.particles) {
            data.toBuffer(buffer);
        }
    }

    public static ServerParticlePacket decode(FriendlyByteBuf buffer) {
        ServerParticlePacket packet = new ServerParticlePacket();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            packet.particles.add(ParticleData.fromBuffer(buffer));
        }
        return packet;
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            for (ParticleData data : this.particles) {
                ClientOperations.addParticle(data.particle, data.x, data.y, data.z, data.velX, data.velY, data.velZ, data.amount);
            }
        });
        context.get().setPacketHandled(true);
    }

    private static <T extends ParticleOptions> T deserializeParticle(FriendlyByteBuf buffer, ParticleType<T> particleType) {
        return (T)particleType.m_123743_().m_6507_(particleType, buffer);
    }

    private record ParticleData(ParticleOptions particle, double x, double y, double z, double velX, double velY, double velZ, int amount) {
        private void toBuffer(FriendlyByteBuf buffer) {
            buffer.writeInt(Registry.f_122829_.m_7447_((Object)this.particle.m_6012_()));
            this.particle.m_7711_(buffer);
            buffer.writeDouble(this.x);
            buffer.writeDouble(this.y);
            buffer.writeDouble(this.z);
            buffer.writeDouble(this.velX);
            buffer.writeDouble(this.velY);
            buffer.writeDouble(this.velZ);
            buffer.writeInt(this.amount);
        }

        private static ParticleData fromBuffer(FriendlyByteBuf buffer) {
            ParticleType particle = (ParticleType)Registry.f_122829_.m_7942_(buffer.readInt());
            if (particle == null) {
                particle = ParticleTypes.f_194652_;
            }
            return new ParticleData((ParticleOptions)ServerParticlePacket.deserializeParticle(buffer, particle), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readInt());
        }
    }
}

