/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.client.MusicPlayer;
import net.tslat.aoa3.common.packet.packets.AoAPacket;

public class MusicPacket
implements AoAPacket {
    private final boolean startingMusic;
    private final ResourceLocation id;

    public MusicPacket(boolean startingMusic, ResourceLocation id) {
        this.startingMusic = startingMusic;
        this.id = id;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.startingMusic);
        buffer.m_130070_(this.id.toString());
    }

    public static MusicPacket decode(FriendlyByteBuf buffer) {
        return new MusicPacket(buffer.readBoolean(), new ResourceLocation(buffer.m_130136_(Short.MAX_VALUE)));
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        if (this.startingMusic) {
            MusicPlayer.playMusic(this.id);
        } else {
            MusicPlayer.stopMusic(this.id);
        }
        context.get().setPacketHandled(true);
    }
}

