/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.RenderUtil;
import org.apache.commons.lang3.math.NumberUtils;

public interface AoAResourceRenderer {
    public static final AoAResourceRenderer DEFAULT = new AoAResourceRenderer(){};

    default public void renderInHud(PoseStack matrix, AoAResource.Instance resource, float partialTicks, @Nullable String valueOverride) {
        ResourceLocation resourceId = AoARegistries.AOA_RESOURCES.getId(resource.type());
        matrix.m_85836_();
        matrix.m_85841_(0.5f, 0.5f, 0.0f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation(resourceId.m_135827_(), "textures/gui/aoaresource/" + resourceId.m_135815_() + ".png"));
        int renderWidth = this.hudRenderWidth(resource) * 2;
        int renderHeight = this.hudRenderHeight(resource) * 2;
        float currentValue = resource.getCurrentValue();
        String value = String.valueOf((int)currentValue);
        if (valueOverride != null) {
            if (valueOverride.equals("-1")) {
                currentValue = resource.getMaxValue();
                value = "";
            } else if (NumberUtils.isParsable((String)valueOverride)) {
                currentValue = Float.parseFloat(valueOverride);
                value = String.valueOf((int)currentValue);
            } else {
                currentValue = resource.getMaxValue();
                value = valueOverride;
            }
        }
        float percentOfMax = (float)Math.floor(Math.min(currentValue, resource.getMaxValue()) / resource.getMaxValue() * (float)renderWidth);
        RenderUtil.renderScaledCustomSizedTexture(matrix, 0.0f, 0.0f, 0.0f, 0.0f, renderWidth, renderHeight, renderWidth, renderHeight, renderWidth, renderHeight * 3);
        RenderUtil.renderScaledCustomSizedTexture(matrix, 0.0f, 0.0f, 0.0f, percentOfMax == (float)renderWidth ? (float)(renderHeight * 2) : (float)renderHeight, percentOfMax, renderHeight, percentOfMax, renderHeight, renderWidth, renderHeight * 3);
        RenderUtil.drawCenteredScaledString(matrix, Minecraft.m_91087_().f_91062_, value, 26.0f, 29.0f, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
        matrix.m_85849_();
    }

    default public void renderInGui(PoseStack matrix, AoAResource.Instance resource, float partialTicks, int mouseX, int mouseY) {
    }

    default public int hudRenderWidth(AoAResource.Instance resource) {
        return 25;
    }

    default public int hudRenderHeight(AoAResource.Instance resource) {
        return 25;
    }

    default public int guiRenderWidth(AoAResource.Instance resource) {
        return 25;
    }

    default public int guiRenderHeight(AoAResource.Instance resource) {
        return 25;
    }

    public static enum HudResourcesPosition {
        Top_Right,
        Top_Left,
        Bottom_Right,
        Bottom_Left;

    }
}

