/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.util.RenderUtil;

public final class CustomDimensionRenders {
    public static void init() {
        AdventOfAscension.modEventBus.addListener(EventPriority.NORMAL, false, RegisterDimensionSpecialEffectsEvent.class, ev -> {
            ev.register(VoidSky.ID, (DimensionSpecialEffects)new VoidSky());
            ev.register(CelestialOnly.ID, (DimensionSpecialEffects)new CelestialOnly());
            ev.register(Shyrelands.ID, (DimensionSpecialEffects)new Shyrelands());
            ev.register(Lunalus.ID, (DimensionSpecialEffects)new Lunalus());
        });
    }

    public static class VoidSky
    extends DimensionSpecialEffects {
        public static final ResourceLocation ID = new ResourceLocation("aoa3", "void_sky");

        public VoidSky() {
            super(Float.NaN, false, DimensionSpecialEffects.SkyType.NONE, false, true);
        }

        public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f projectionMatrix) {
            return true;
        }

        public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
            return true;
        }

        public boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTick, LightTexture lightTexture, double camX, double camY, double camZ) {
            return true;
        }

        public boolean tickRain(ClientLevel level, int ticks, Camera camera) {
            return true;
        }

        public Vec3 m_5927_(Vec3 biomeFogColour, float celestialAngle) {
            return biomeFogColour;
        }

        public boolean m_5781_(int posX, int posZ) {
            return false;
        }

        @Nullable
        public float[] m_7518_(float celestialAngle, float partialTicks) {
            return null;
        }
    }

    public static class CelestialOnly
    extends DimensionSpecialEffects {
        public static final ResourceLocation ID = new ResourceLocation("aoa3", "celestial_only");

        public CelestialOnly() {
            super(Float.NaN, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
        }

        public Vec3 m_5927_(Vec3 biomeFogColour, float celestialAngle) {
            return biomeFogColour.m_82542_((double)(celestialAngle * 0.94f + 0.06f), (double)(celestialAngle * 0.94f + 0.06f), (double)(celestialAngle * 0.91f + 0.09f));
        }

        public boolean m_5781_(int posX, int posZ) {
            return false;
        }
    }

    public static class Shyrelands
    extends DimensionSpecialEffects {
        public static final ResourceLocation ID = new ResourceLocation("aoa3", "shyrelands");

        public Shyrelands() {
            super(40.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, true);
        }

        public Vec3 m_5927_(Vec3 biomeFogColour, float celestialAngle) {
            return biomeFogColour.m_82542_((double)(celestialAngle * 0.94f + 0.06f), (double)(celestialAngle * 0.94f + 0.06f), (double)(celestialAngle * 0.91f + 0.09f));
        }

        public boolean m_5781_(int posX, int posZ) {
            return false;
        }
    }

    public static class Lunalus
    extends DimensionSpecialEffects {
        public static final ResourceLocation ID = new ResourceLocation("aoa3", "lunalus");
        private static final ResourceLocation TEXTURE = new ResourceLocation("aoa3", "textures/gui/realmstonegui/background.png");

        public Lunalus() {
            super(Float.NaN, true, DimensionSpecialEffects.SkyType.NONE, false, true);
        }

        public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69458_((boolean)false);
            RenderUtil.prepRenderTexture(TEXTURE);
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            for (int i = 0; i < 6; ++i) {
                poseStack.m_85836_();
                switch (i) {
                    case 1: {
                        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                        break;
                    }
                    case 2: {
                        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                        break;
                    }
                    case 3: {
                        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                        break;
                    }
                    case 4: {
                        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
                        break;
                    }
                    case 5: {
                        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f));
                        break;
                    }
                }
                Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                buffer.m_85982_(matrix4f, -100.0f, -100.0f, -100.0f).m_7421_(0.0f, 0.0f).m_6122_(150, 150, 150, 255).m_5752_();
                buffer.m_85982_(matrix4f, -100.0f, -100.0f, 100.0f).m_7421_(0.0f, 1.0f).m_6122_(150, 150, 150, 255).m_5752_();
                buffer.m_85982_(matrix4f, 100.0f, -100.0f, 100.0f).m_7421_(1.0f, 1.0f).m_6122_(150, 150, 150, 255).m_5752_();
                buffer.m_85982_(matrix4f, 100.0f, -100.0f, -100.0f).m_7421_(1.0f, 0.0f).m_6122_(150, 150, 150, 255).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
                poseStack.m_85849_();
            }
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69493_();
            RenderSystem.m_69461_();
            return true;
        }

        public Vec3 m_5927_(Vec3 biomeFogColour, float celestialAngle) {
            return biomeFogColour;
        }

        public boolean m_5781_(int posX, int posZ) {
            return false;
        }

        @Nullable
        public float[] m_7518_(float celestialAngle, float partialTicks) {
            return null;
        }
    }
}

