/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.EventPriority;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.AoAKeybinds;
import net.tslat.aoa3.client.render.custom.AoAResourceRenderer;
import net.tslat.aoa3.client.render.custom.AoASkillRenderer;
import net.tslat.aoa3.client.render.custom.EnergyResourceRenderer;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.player.ClientPlayerDataManager;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RenderUtil;

public final class AoAGuiElementRenderers {
    private static final HashMap<AoASkill, AoASkillRenderer> SKILL_RENDERERS = new HashMap();
    private static final HashMap<AoAResource, AoAResourceRenderer> RESOURCE_RENDERERS = new HashMap();
    public static int resourcesRenderHeightOffset = 0;

    public static void init() {
        AdventOfAscension.modEventBus.addListener(EventPriority.NORMAL, false, RegisterGuiOverlaysEvent.class, ev -> {
            ev.registerAbove(VanillaGuiOverlay.POTION_ICONS.id(), "aoa_resources", AoAGuiElementRenderers::renderResources);
            ev.registerAbove(VanillaGuiOverlay.POTION_ICONS.id(), "aoa_skills", AoAGuiElementRenderers::renderSkills);
        });
    }

    public static void lateInit() {
        AoAGuiElementRenderers.registerResourceRenderer((AoAResource)AoAResources.ENERGY.get(), new EnergyResourceRenderer());
    }

    public static AoAResourceRenderer getResourceRenderer(AoAResource resource) {
        return RESOURCE_RENDERERS.getOrDefault(resource, AoAResourceRenderer.DEFAULT);
    }

    public static AoASkillRenderer getSkillRenderer(AoASkill skill) {
        return SKILL_RENDERERS.getOrDefault(skill, AoASkillRenderer.DEFAULT);
    }

    public static void registerResourceRenderer(AoAResource resource, AoAResourceRenderer renderer) {
        RESOURCE_RENDERERS.put(resource, renderer);
    }

    public static void registerSkillRenderer(AoASkill skill, AoASkillRenderer renderer) {
        SKILL_RENDERERS.put(skill, renderer);
    }

    private static void renderResources(ForgeGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        int horizontalAdjuster = (Boolean)AoAConfigs.CLIENT.hudResourcesHorizontal.get() != false ? 1 : 0;
        int verticalAdjuster = horizontalAdjuster == 1 ? 0 : 1;
        int potionRenderOffset = 0;
        int x = 0;
        int y = 0;
        if (mc.f_91074_ == null || mc.f_91074_.m_5833_()) {
            return;
        }
        switch ((AoAResourceRenderer.HudResourcesPosition)((Object)AoAConfigs.CLIENT.hudResourcesPosition.get())) {
            case Bottom_Right: {
                horizontalAdjuster *= -1;
                verticalAdjuster *= -1;
                x = window.m_85445_();
                y = window.m_85446_();
                break;
            }
            case Bottom_Left: {
                verticalAdjuster *= -1;
                y = window.m_85446_();
                break;
            }
            case Top_Right: {
                horizontalAdjuster *= -1;
                x = window.m_85445_();
                y = potionRenderOffset = RenderUtil.getPotionGuiRenderOffset();
            }
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 0.0);
        x = 0;
        y = 0;
        if (AoAKeybinds.statusResourceGui) {
            int lastHeight = 0;
            for (AoAResource.Instance resource : ClientPlayerDataManager.get().getResources()) {
                AoAResourceRenderer renderer = AoAGuiElementRenderers.getResourceRenderer(resource.type());
                lastHeight = (y += renderer.hudRenderHeight(resource) * verticalAdjuster) + renderer.hudRenderHeight(resource);
                poseStack.m_85836_();
                poseStack.m_85837_((double)(x += renderer.hudRenderWidth(resource) * horizontalAdjuster), (double)y, 0.0);
                renderer.renderInHud(poseStack, resource, partialTick, null);
                poseStack.m_85849_();
            }
            y = lastHeight;
        } else if (AoAKeybinds.statusResourceGuiMessage & AoAKeybinds.RESOURCE_GUI.getKey().m_84873_() != -1) {
            poseStack.m_85841_(0.5f, 0.5f, 0.0f);
            MutableComponent locale = LocaleUtil.getLocaleMessage("gui.aoa3.resources.showtip", AoAKeybinds.RESOURCE_GUI.m_90863_());
            RenderUtil.drawCenteredScaledMessage(poseStack, mc.f_91062_, (Component)locale, -((int)((float)mc.f_91062_.m_92852_((FormattedText)locale) * 0.75f)), (int)((float)(y + 4) / 2.0f), 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
            Objects.requireNonNull(mc.f_91062_);
            y = y + 4 + 9 / 2;
        }
        poseStack.m_85849_();
        resourcesRenderHeightOffset = (AoAConfigs.CLIENT.hudResourcesPosition.get() == AoAResourceRenderer.HudResourcesPosition.Top_Right ? y : 0) + potionRenderOffset;
    }

    private static void renderSkills(ForgeGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        int x = 0;
        int y = 0;
        if (mc.f_91074_ == null || mc.f_91074_.m_5833_()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)window.m_85445_(), (double)resourcesRenderHeightOffset, 0.0);
        RenderSystem.m_69465_();
        if (AoAKeybinds.statusSkillGui) {
            int maxHeight = 0;
            int cumulativeXOffset = 0;
            for (AoASkill.Instance skill : ClientPlayerDataManager.get().getSkills()) {
                AoASkillRenderer renderer = AoAGuiElementRenderers.getSkillRenderer(skill.type());
                int xOffset = renderer.hudRenderWidth(skill);
                x -= xOffset;
                maxHeight = Math.max(maxHeight, renderer.hudRenderHeight(skill));
                if ((cumulativeXOffset += xOffset) >= xOffset * 6) {
                    y += maxHeight;
                    x += cumulativeXOffset - xOffset;
                    maxHeight = 0;
                    cumulativeXOffset = 0;
                }
                poseStack.m_85836_();
                poseStack.m_85837_((double)x, (double)y, 0.0);
                renderer.renderInHud(poseStack, skill, partialTick, (AoASkillRenderer.ProgressRenderType)((Object)AoAConfigs.CLIENT.hudSkillProgressRenderType.get()), true);
                poseStack.m_85849_();
            }
        } else if (AoAKeybinds.statusSkillGuiMessage & AoAKeybinds.SKILL_GUI.getKey().m_84873_() != -1) {
            poseStack.m_85841_(0.5f, 0.5f, 1.0f);
            MutableComponent locale = LocaleUtil.getLocaleMessage("gui.aoa3.skills.showtip", AoAKeybinds.SKILL_GUI.m_90863_());
            RenderUtil.drawCenteredScaledMessage(poseStack, mc.f_91062_, (Component)locale, -((int)((float)mc.f_91062_.m_92852_((FormattedText)locale) * 0.75f)), (int)((float)y / 2.0f) + 1, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
        }
        RenderSystem.m_69482_();
        poseStack.m_85849_();
    }
}

