/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;

public final class AoAAnimations {
    public static final AnimationBuilder IDLE = new AnimationBuilder().addAnimation("misc.idle", Boolean.valueOf(true));
    public static final AnimationBuilder RECOVER = new AnimationBuilder().addAnimation("misc.rest", Boolean.valueOf(false));
    public static final AnimationBuilder EAT = new AnimationBuilder().addAnimation("misc.eat", Boolean.valueOf(false));
    public static final AnimationBuilder SUCCEED = new AnimationBuilder().addAnimation("misc.succeed", Boolean.valueOf(false));
    public static final AnimationBuilder SPAWN = new AnimationBuilder().addAnimation("misc.spawn", Boolean.valueOf(false));
    public static final AnimationBuilder INTERACT = new AnimationBuilder().addAnimation("misc.interact", Boolean.valueOf(false)).addAnimation("misc.interact.hold", Boolean.valueOf(true));
    public static final AnimationBuilder INTERACT_END = new AnimationBuilder().addAnimation("misc.interact.end", Boolean.valueOf(false));
    public static final AnimationBuilder WALK = new AnimationBuilder().addAnimation("move.walk", Boolean.valueOf(true));
    public static final AnimationBuilder RUN = new AnimationBuilder().addAnimation("move.run", Boolean.valueOf(true));
    public static final AnimationBuilder FLY = new AnimationBuilder().addAnimation("move.fly", Boolean.valueOf(true));
    public static final AnimationBuilder SWIM = new AnimationBuilder().addAnimation("move.swim", Boolean.valueOf(true));
    public static final AnimationBuilder ATTACK_SWING = new AnimationBuilder().addAnimation("attack.swing", Boolean.valueOf(false));
    public static final AnimationBuilder ATTACK_THROW = new AnimationBuilder().addAnimation("attack.throw", Boolean.valueOf(false));
    public static final AnimationBuilder ATTACK_BITE = new AnimationBuilder().addAnimation("attack.bite", Boolean.valueOf(false));
    public static final AnimationBuilder ATTACK_SLAM = new AnimationBuilder().addAnimation("attack.slam", Boolean.valueOf(false));
    public static final AnimationBuilder ATTACK_STOMP = new AnimationBuilder().addAnimation("attack.stomp", Boolean.valueOf(false));
    public static final AnimationBuilder ATTACK_STRIKE = new AnimationBuilder().addAnimation("attack.strike", Boolean.valueOf(false));
    public static final AnimationBuilder ATTACK_SPIN = new AnimationBuilder().addAnimation("attack.spin", Boolean.valueOf(false));
    public static final AnimationBuilder ATTACK_FLYING_BITE = new AnimationBuilder().addAnimation("attack.midair_bite", Boolean.valueOf(false));
    public static final AnimationBuilder ATTACK_SHOOT = new AnimationBuilder().addAnimation("attack.shoot", Boolean.valueOf(false));
    public static final AnimationBuilder ATTACK_BLOCK = new AnimationBuilder().addAnimation("attack.block", Boolean.valueOf(false)).addAnimation("attack.block.hold", Boolean.valueOf(true));
    public static final AnimationBuilder ATTACK_CHARGE = new AnimationBuilder().addAnimation("attack.charge", Boolean.valueOf(false)).addAnimation("attack.charge.hold", Boolean.valueOf(true));
    public static final AnimationBuilder ATTACK_CHARGE_END = new AnimationBuilder().addAnimation("attack.charge.end", Boolean.valueOf(false));
    public static final AnimationBuilder ATTACK_SWIPE_LEFT = new AnimationBuilder().addAnimation("attack.swipe_left", Boolean.valueOf(false));
    public static final AnimationBuilder ATTACK_SWIPE_RIGHT = new AnimationBuilder().addAnimation("attack.swipe_right", Boolean.valueOf(false));
    public static final AnimationBuilder ATTACK_SHOOT_ALTERNATE = new AnimationBuilder().addAnimation("attack.shoot_alternate", Boolean.valueOf(false));

    public static <T extends Entity> AnimationController<T> genericIdleController(T entity) {
        return new AnimationController(entity, "movement", 0.0f, event -> {
            event.getController().setAnimation(IDLE);
            return PlayState.CONTINUE;
        });
    }

    public static <T extends Entity> AnimationController<T> genericWalkController(T entity) {
        return new AnimationController(entity, "movement", 0.0f, event -> {
            if (event.isMoving()) {
                event.getController().setAnimation(WALK);
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        });
    }

    public static <T extends Entity> AnimationController<T> genericSwimController(T entity) {
        return new AnimationController(entity, "movement", 0.0f, event -> {
            if (event.isMoving()) {
                event.getController().setAnimation(SWIM);
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        });
    }

    public static <T extends Entity> AnimationController<T> genericSwimIdleController(T entity) {
        return new AnimationController(entity, "movement", 0.0f, event -> {
            if (event.isMoving()) {
                event.getController().setAnimation(SWIM);
            } else {
                event.getController().setAnimation(IDLE);
            }
            return PlayState.CONTINUE;
        });
    }

    public static <T extends Entity> AnimationController<T> genericWalkIdleController(T entity) {
        return new AnimationController(entity, "movement", 0.0f, event -> {
            if (event.isMoving()) {
                event.getController().setAnimation(WALK);
            } else {
                event.getController().setAnimation(IDLE);
            }
            return PlayState.CONTINUE;
        });
    }

    public static <T extends Entity> AnimationController<T> genericFlyController(T entity) {
        return new AnimationController(entity, "movement", 0.0f, event -> {
            event.getController().setAnimation(FLY);
            return PlayState.CONTINUE;
        });
    }

    public static <T extends Entity> AnimationController<T> genericFlyIdleController(T entity) {
        return new AnimationController(entity, "movement", 0.0f, event -> {
            if (event.isMoving()) {
                event.getController().setAnimation(FLY);
            } else {
                event.getController().setAnimation(IDLE);
            }
            return PlayState.CONTINUE;
        });
    }

    public static <T extends LivingEntity> AnimationController<T> genericWalkRunIdleController(T entity) {
        return new AnimationController(entity, "movement", 0.0f, event -> {
            if (event.isMoving()) {
                if (entity.m_20142_()) {
                    event.getController().setAnimation(RUN);
                } else {
                    event.getController().setAnimation(WALK);
                }
            } else {
                event.getController().setAnimation(IDLE);
            }
            return PlayState.CONTINUE;
        });
    }

    public static <T extends LivingEntity> AnimationController<T> genericWalkRunSwimIdleController(T entity) {
        return new AnimationController(entity, "movement", 0.0f, event -> {
            if (event.isMoving()) {
                if (entity.m_20142_()) {
                    event.getController().setAnimation(RUN);
                } else {
                    event.getController().setAnimation(WALK);
                }
            } else {
                event.getController().setAnimation(IDLE);
            }
            return PlayState.CONTINUE;
        });
    }

    public static <T extends LivingEntity> AnimationController<T> genericAttackController(T entity, AnimationBuilder attackAnimation) {
        return new AnimationController(entity, "attacking", 0.0f, event -> {
            if (entity.f_20911_) {
                event.getController().setAnimation(attackAnimation);
                return PlayState.CONTINUE;
            }
            event.getController().markNeedsReload();
            return PlayState.STOP;
        });
    }

    public static <T extends LivingEntity> AnimationController<T> dynamicAttackController(T entity, Function<AnimationEvent<T>, AnimationBuilder> animationSupplier) {
        return new AnimationController(entity, "attacking", 0.0f, event -> {
            if (entity.f_20911_) {
                event.getController().setAnimation((AnimationBuilder)animationSupplier.apply(event));
                return PlayState.CONTINUE;
            }
            event.getController().markNeedsReload();
            return PlayState.STOP;
        });
    }

    public static <T extends LivingEntity> AnimationController<T> customAttackController(T entity, AnimationController.IAnimationPredicate<T> controllerPredicate) {
        return new AnimationController(entity, "attacking", 0.0f, controllerPredicate);
    }

    public static <T extends Entity> AnimationController<T> genericSpawnController(T entity, int spawnTicks) {
        return new AnimationController(entity, "spawning", 0.0f, event -> {
            if (entity.f_19797_ < spawnTicks) {
                event.getController().setAnimation(SPAWN);
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        });
    }

    public static <T extends LivingEntity> AnimationController<T> genericHeldPoseController(T entity, AnimationBuilder poseToHold, @Nullable AnimationBuilder animOnRelease, Predicate<T> posePredicate) {
        return new AnimationController(entity, "posing", 0.0f, event -> {
            AnimationController controller = event.getController();
            if (posePredicate.test(entity)) {
                controller.setAnimation(poseToHold);
                return PlayState.CONTINUE;
            }
            if (animOnRelease != null && controller.getCurrentAnimation() != null) {
                controller.setAnimation(animOnRelease);
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        });
    }
}

